/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeThreadPoolInfo
implements JsonpSerializable {
    @Nullable
    private final Integer core;
    @Nullable
    private final String keepAlive;
    @Nullable
    private final Integer max;
    private final int queueSize;
    @Nullable
    private final Integer size;
    private final String type;
    public static final JsonpDeserializer<NodeThreadPoolInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeThreadPoolInfo::setupNodeThreadPoolInfoDeserializer);

    private NodeThreadPoolInfo(Builder builder) {
        this.core = builder.core;
        this.keepAlive = builder.keepAlive;
        this.max = builder.max;
        this.queueSize = ApiTypeHelper.requireNonNull(builder.queueSize, this, "queueSize");
        this.size = builder.size;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static NodeThreadPoolInfo of(Function<Builder, ObjectBuilder<NodeThreadPoolInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer core() {
        return this.core;
    }

    @Nullable
    public final String keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public final Integer max() {
        return this.max;
    }

    public final int queueSize() {
        return this.queueSize;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.core != null) {
            generator.writeKey("core");
            generator.write(this.core.intValue());
        }
        if (this.keepAlive != null) {
            generator.writeKey("keep_alive");
            generator.write(this.keepAlive);
        }
        if (this.max != null) {
            generator.writeKey("max");
            generator.write(this.max.intValue());
        }
        generator.writeKey("queue_size");
        generator.write(this.queueSize);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupNodeThreadPoolInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::core, JsonpDeserializer.integerDeserializer(), "core");
        op.add(Builder::keepAlive, JsonpDeserializer.stringDeserializer(), "keep_alive");
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max");
        op.add(Builder::queueSize, JsonpDeserializer.integerDeserializer(), "queue_size");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeThreadPoolInfo> {
        @Nullable
        private Integer core;
        @Nullable
        private String keepAlive;
        @Nullable
        private Integer max;
        private Integer queueSize;
        @Nullable
        private Integer size;
        private String type;

        public final Builder core(@Nullable Integer value) {
            this.core = value;
            return this;
        }

        public final Builder keepAlive(@Nullable String value) {
            this.keepAlive = value;
            return this;
        }

        public final Builder max(@Nullable Integer value) {
            this.max = value;
            return this;
        }

        public final Builder queueSize(int value) {
            this.queueSize = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeThreadPoolInfo build() {
            this._checkSingleUse();
            return new NodeThreadPoolInfo(this);
        }
    }
}

