/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.transform.RetentionPolicy;
import co.elastic.clients.elasticsearch.transform.RetentionPolicyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TimeRetentionPolicy
implements RetentionPolicyVariant,
JsonpSerializable {
    private final String field;
    private final Time maxAge;
    public static final JsonpDeserializer<TimeRetentionPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimeRetentionPolicy::setupTimeRetentionPolicyDeserializer);

    private TimeRetentionPolicy(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.maxAge = ApiTypeHelper.requireNonNull(builder.maxAge, this, "maxAge");
    }

    public static TimeRetentionPolicy of(Function<Builder, ObjectBuilder<TimeRetentionPolicy>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public RetentionPolicy.Kind _retentionPolicyKind() {
        return RetentionPolicy.Kind.Time;
    }

    public final String field() {
        return this.field;
    }

    public final Time maxAge() {
        return this.maxAge;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("max_age");
        this.maxAge.serialize(generator, mapper);
    }

    protected static void setupTimeRetentionPolicyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::maxAge, Time._DESERIALIZER, "max_age");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TimeRetentionPolicy> {
        private String field;
        private Time maxAge;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder maxAge(Time value) {
            this.maxAge = value;
            return this;
        }

        public final Builder maxAge(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxAge(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TimeRetentionPolicy build() {
            this._checkSingleUse();
            return new TimeRetentionPolicy(this);
        }
    }
}

