/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ActionWebhook
implements JsonpSerializable {
    private final String host;
    private final int port;
    public static final JsonpDeserializer<ActionWebhook> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ActionWebhook::setupActionWebhookDeserializer);

    private ActionWebhook(Builder builder) {
        this.host = ApiTypeHelper.requireNonNull(builder.host, this, "host");
        this.port = ApiTypeHelper.requireNonNull(builder.port, this, "port");
    }

    public static ActionWebhook of(Function<Builder, ObjectBuilder<ActionWebhook>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String host() {
        return this.host;
    }

    public final int port() {
        return this.port;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("host");
        generator.write(this.host);
        generator.writeKey("port");
        generator.write(this.port);
    }

    protected static void setupActionWebhookDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::port, JsonpDeserializer.integerDeserializer(), "port");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ActionWebhook> {
        private String host;
        private Integer port;

        public final Builder host(String value) {
            this.host = value;
            return this;
        }

        public final Builder port(int value) {
            this.port = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ActionWebhook build() {
            this._checkSingleUse();
            return new ActionWebhook(this);
        }
    }
}

