/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Schedule;
import co.elastic.clients.elasticsearch.watcher.ScheduleVariant;
import co.elastic.clients.elasticsearch.watcher.TimeOfDay;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class DailySchedule
implements ScheduleVariant,
JsonpSerializable {
    private final List<TimeOfDay> at;
    public static final JsonpDeserializer<DailySchedule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DailySchedule::setupDailyScheduleDeserializer);

    private DailySchedule(Builder builder) {
        this.at = ApiTypeHelper.unmodifiableRequired(builder.at, (Object)this, "at");
    }

    public static DailySchedule of(Function<Builder, ObjectBuilder<DailySchedule>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Schedule.Kind _scheduleKind() {
        return Schedule.Kind.Daily;
    }

    public final List<TimeOfDay> at() {
        return this.at;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.at)) {
            generator.writeKey("at");
            generator.writeStartArray();
            for (TimeOfDay item0 : this.at) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDailyScheduleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::at, JsonpDeserializer.arrayDeserializer(TimeOfDay._DESERIALIZER), "at");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DailySchedule> {
        private List<TimeOfDay> at;

        public final Builder at(List<TimeOfDay> list) {
            this.at = Builder._listAddAll(this.at, list);
            return this;
        }

        public final Builder at(TimeOfDay value, TimeOfDay ... values) {
            this.at = Builder._listAdd(this.at, value, values);
            return this;
        }

        public final Builder at(Function<TimeOfDay.Builder, ObjectBuilder<TimeOfDay>> fn) {
            return this.at(fn.apply(new TimeOfDay.Builder()).build(), new TimeOfDay[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DailySchedule build() {
            this._checkSingleUse();
            return new DailySchedule(this);
        }
    }
}

