/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.stats.IndicesStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndicesStatsResponse
implements JsonpSerializable {
    private final Map<String, IndicesStats> indices;
    private final ShardStatistics shards;
    private final IndicesStats all;
    public static final JsonpDeserializer<IndicesStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesStatsResponse::setupIndicesStatsResponseDeserializer);

    private IndicesStatsResponse(Builder builder) {
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
        this.all = ApiTypeHelper.requireNonNull(builder.all, this, "all");
    }

    public static IndicesStatsResponse of(Function<Builder, ObjectBuilder<IndicesStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, IndicesStats> indices() {
        return this.indices;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final IndicesStats all() {
        return this.all;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, IndicesStats> item0 : this.indices.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("_all");
        this.all.serialize(generator, mapper);
    }

    protected static void setupIndicesStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndicesStats._DESERIALIZER), "indices");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::all, IndicesStats._DESERIALIZER, "_all");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndicesStatsResponse> {
        @Nullable
        private Map<String, IndicesStats> indices;
        private ShardStatistics shards;
        private IndicesStats all;

        public final Builder indices(Map<String, IndicesStats> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        public final Builder indices(String key, IndicesStats value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        public final Builder indices(String key, Function<IndicesStats.Builder, ObjectBuilder<IndicesStats>> fn) {
            return this.indices(key, fn.apply(new IndicesStats.Builder()).build());
        }

        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder all(IndicesStats value) {
            this.all = value;
            return this;
        }

        public final Builder all(Function<IndicesStats.Builder, ObjectBuilder<IndicesStats>> fn) {
            return this.all(fn.apply(new IndicesStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndicesStatsResponse build() {
            this._checkSingleUse();
            return new IndicesStatsResponse(this);
        }
    }
}

