/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.segments;

import co.elastic.clients.elasticsearch.indices.segments.Segment;
import co.elastic.clients.elasticsearch.indices.segments.ShardSegmentRouting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class ShardsSegment
implements JsonpSerializable {
    private final int numCommittedSegments;
    private final ShardSegmentRouting routing;
    private final int numSearchSegments;
    private final Map<String, Segment> segments;
    public static final JsonpDeserializer<ShardsSegment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsSegment::setupShardsSegmentDeserializer);

    private ShardsSegment(Builder builder) {
        this.numCommittedSegments = ApiTypeHelper.requireNonNull(builder.numCommittedSegments, this, "numCommittedSegments");
        this.routing = ApiTypeHelper.requireNonNull(builder.routing, this, "routing");
        this.numSearchSegments = ApiTypeHelper.requireNonNull(builder.numSearchSegments, this, "numSearchSegments");
        this.segments = ApiTypeHelper.unmodifiableRequired(builder.segments, (Object)this, "segments");
    }

    public static ShardsSegment of(Function<Builder, ObjectBuilder<ShardsSegment>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int numCommittedSegments() {
        return this.numCommittedSegments;
    }

    public final ShardSegmentRouting routing() {
        return this.routing;
    }

    public final int numSearchSegments() {
        return this.numSearchSegments;
    }

    public final Map<String, Segment> segments() {
        return this.segments;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("num_committed_segments");
        generator.write(this.numCommittedSegments);
        generator.writeKey("routing");
        this.routing.serialize(generator, mapper);
        generator.writeKey("num_search_segments");
        generator.write(this.numSearchSegments);
        if (ApiTypeHelper.isDefined(this.segments)) {
            generator.writeKey("segments");
            generator.writeStartObject();
            for (Map.Entry<String, Segment> item0 : this.segments.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupShardsSegmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numCommittedSegments, JsonpDeserializer.integerDeserializer(), "num_committed_segments");
        op.add(Builder::routing, ShardSegmentRouting._DESERIALIZER, "routing");
        op.add(Builder::numSearchSegments, JsonpDeserializer.integerDeserializer(), "num_search_segments");
        op.add(Builder::segments, JsonpDeserializer.stringMapDeserializer(Segment._DESERIALIZER), "segments");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardsSegment> {
        private Integer numCommittedSegments;
        private ShardSegmentRouting routing;
        private Integer numSearchSegments;
        private Map<String, Segment> segments;

        public final Builder numCommittedSegments(int value) {
            this.numCommittedSegments = value;
            return this;
        }

        public final Builder routing(ShardSegmentRouting value) {
            this.routing = value;
            return this;
        }

        public final Builder routing(Function<ShardSegmentRouting.Builder, ObjectBuilder<ShardSegmentRouting>> fn) {
            return this.routing(fn.apply(new ShardSegmentRouting.Builder()).build());
        }

        public final Builder numSearchSegments(int value) {
            this.numSearchSegments = value;
            return this;
        }

        public final Builder segments(Map<String, Segment> map) {
            this.segments = Builder._mapPutAll(this.segments, map);
            return this;
        }

        public final Builder segments(String key, Segment value) {
            this.segments = Builder._mapPut(this.segments, key, value);
            return this;
        }

        public final Builder segments(String key, Function<Segment.Builder, ObjectBuilder<Segment>> fn) {
            return this.segments(key, fn.apply(new Segment.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardsSegment build() {
            this._checkSingleUse();
            return new ShardsSegment(this);
        }
    }
}

