/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetRecordsResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetRecordsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean desc;
    @Nullable
    private final DateTime end;
    @Nullable
    private final Boolean excludeInterim;
    @Nullable
    private final Integer from;
    private final String jobId;
    @Nullable
    private final Page page;
    @Nullable
    private final Double recordScore;
    @Nullable
    private final Integer size;
    @Nullable
    private final String sort;
    @Nullable
    private final DateTime start;
    public static final JsonpDeserializer<GetRecordsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetRecordsRequest::setupGetRecordsRequestDeserializer);
    public static final Endpoint<GetRecordsRequest, GetRecordsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetRecordsRequest, GetRecordsResponse>("es/ml.get_records", request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/records");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetRecordsResponse._DESERIALIZER);

    private GetRecordsRequest(Builder builder) {
        this.desc = builder.desc;
        this.end = builder.end;
        this.excludeInterim = builder.excludeInterim;
        this.from = builder.from;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.page = builder.page;
        this.recordScore = builder.recordScore;
        this.size = builder.size;
        this.sort = builder.sort;
        this.start = builder.start;
    }

    public static GetRecordsRequest of(Function<Builder, ObjectBuilder<GetRecordsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean desc() {
        return this.desc;
    }

    @Nullable
    public final DateTime end() {
        return this.end;
    }

    @Nullable
    public final Boolean excludeInterim() {
        return this.excludeInterim;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Page page() {
        return this.page;
    }

    @Nullable
    public final Double recordScore() {
        return this.recordScore;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final String sort() {
        return this.sort;
    }

    @Nullable
    public final DateTime start() {
        return this.start;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.desc != null) {
            generator.writeKey("desc");
            generator.write(this.desc.booleanValue());
        }
        if (this.end != null) {
            generator.writeKey("end");
            this.end.serialize(generator, mapper);
        }
        if (this.excludeInterim != null) {
            generator.writeKey("exclude_interim");
            generator.write(this.excludeInterim.booleanValue());
        }
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
        if (this.recordScore != null) {
            generator.writeKey("record_score");
            generator.write(this.recordScore.doubleValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.write(this.sort);
        }
        if (this.start != null) {
            generator.writeKey("start");
            this.start.serialize(generator, mapper);
        }
    }

    protected static void setupGetRecordsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::desc, JsonpDeserializer.booleanDeserializer(), "desc");
        op.add(Builder::end, DateTime._DESERIALIZER, "end");
        op.add(Builder::excludeInterim, JsonpDeserializer.booleanDeserializer(), "exclude_interim");
        op.add(Builder::page, Page._DESERIALIZER, "page");
        op.add(Builder::recordScore, JsonpDeserializer.doubleDeserializer(), "record_score");
        op.add(Builder::sort, JsonpDeserializer.stringDeserializer(), "sort");
        op.add(Builder::start, DateTime._DESERIALIZER, "start");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetRecordsRequest> {
        @Nullable
        private Boolean desc;
        @Nullable
        private DateTime end;
        @Nullable
        private Boolean excludeInterim;
        @Nullable
        private Integer from;
        private String jobId;
        @Nullable
        private Page page;
        @Nullable
        private Double recordScore;
        @Nullable
        private Integer size;
        @Nullable
        private String sort;
        @Nullable
        private DateTime start;

        public final Builder desc(@Nullable Boolean value) {
            this.desc = value;
            return this;
        }

        public final Builder end(@Nullable DateTime value) {
            this.end = value;
            return this;
        }

        public final Builder excludeInterim(@Nullable Boolean value) {
            this.excludeInterim = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public final Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        public final Builder recordScore(@Nullable Double value) {
            this.recordScore = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sort(@Nullable String value) {
            this.sort = value;
            return this;
        }

        public final Builder start(@Nullable DateTime value) {
            this.start = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetRecordsRequest build() {
            this._checkSingleUse();
            return new GetRecordsRequest(this);
        }
    }
}

