/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterStateUpdate
implements JsonpSerializable {
    @Nullable
    private final Long count;
    @Nullable
    private final String computationTime;
    @Nullable
    private final Long computationTimeMillis;
    @Nullable
    private final String publicationTime;
    @Nullable
    private final Long publicationTimeMillis;
    @Nullable
    private final String contextConstructionTime;
    @Nullable
    private final Long contextConstructionTimeMillis;
    @Nullable
    private final String commitTime;
    @Nullable
    private final Long commitTimeMillis;
    @Nullable
    private final String completionTime;
    @Nullable
    private final Long completionTimeMillis;
    @Nullable
    private final String masterApplyTime;
    @Nullable
    private final Long masterApplyTimeMillis;
    @Nullable
    private final String notificationTime;
    @Nullable
    private final Long notificationTimeMillis;
    public static final JsonpDeserializer<ClusterStateUpdate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterStateUpdate::setupClusterStateUpdateDeserializer);

    private ClusterStateUpdate(Builder builder) {
        this.count = builder.count;
        this.computationTime = builder.computationTime;
        this.computationTimeMillis = builder.computationTimeMillis;
        this.publicationTime = builder.publicationTime;
        this.publicationTimeMillis = builder.publicationTimeMillis;
        this.contextConstructionTime = builder.contextConstructionTime;
        this.contextConstructionTimeMillis = builder.contextConstructionTimeMillis;
        this.commitTime = builder.commitTime;
        this.commitTimeMillis = builder.commitTimeMillis;
        this.completionTime = builder.completionTime;
        this.completionTimeMillis = builder.completionTimeMillis;
        this.masterApplyTime = builder.masterApplyTime;
        this.masterApplyTimeMillis = builder.masterApplyTimeMillis;
        this.notificationTime = builder.notificationTime;
        this.notificationTimeMillis = builder.notificationTimeMillis;
    }

    public static ClusterStateUpdate of(Function<Builder, ObjectBuilder<ClusterStateUpdate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Nullable
    public final String computationTime() {
        return this.computationTime;
    }

    @Nullable
    public final Long computationTimeMillis() {
        return this.computationTimeMillis;
    }

    @Nullable
    public final String publicationTime() {
        return this.publicationTime;
    }

    @Nullable
    public final Long publicationTimeMillis() {
        return this.publicationTimeMillis;
    }

    @Nullable
    public final String contextConstructionTime() {
        return this.contextConstructionTime;
    }

    @Nullable
    public final Long contextConstructionTimeMillis() {
        return this.contextConstructionTimeMillis;
    }

    @Nullable
    public final String commitTime() {
        return this.commitTime;
    }

    @Nullable
    public final Long commitTimeMillis() {
        return this.commitTimeMillis;
    }

    @Nullable
    public final String completionTime() {
        return this.completionTime;
    }

    @Nullable
    public final Long completionTimeMillis() {
        return this.completionTimeMillis;
    }

    @Nullable
    public final String masterApplyTime() {
        return this.masterApplyTime;
    }

    @Nullable
    public final Long masterApplyTimeMillis() {
        return this.masterApplyTimeMillis;
    }

    @Nullable
    public final String notificationTime() {
        return this.notificationTime;
    }

    @Nullable
    public final Long notificationTimeMillis() {
        return this.notificationTimeMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count.longValue());
        }
        if (this.computationTime != null) {
            generator.writeKey("computation_time");
            generator.write(this.computationTime);
        }
        if (this.computationTimeMillis != null) {
            generator.writeKey("computation_time_millis");
            generator.write(this.computationTimeMillis.longValue());
        }
        if (this.publicationTime != null) {
            generator.writeKey("publication_time");
            generator.write(this.publicationTime);
        }
        if (this.publicationTimeMillis != null) {
            generator.writeKey("publication_time_millis");
            generator.write(this.publicationTimeMillis.longValue());
        }
        if (this.contextConstructionTime != null) {
            generator.writeKey("context_construction_time");
            generator.write(this.contextConstructionTime);
        }
        if (this.contextConstructionTimeMillis != null) {
            generator.writeKey("context_construction_time_millis");
            generator.write(this.contextConstructionTimeMillis.longValue());
        }
        if (this.commitTime != null) {
            generator.writeKey("commit_time");
            generator.write(this.commitTime);
        }
        if (this.commitTimeMillis != null) {
            generator.writeKey("commit_time_millis");
            generator.write(this.commitTimeMillis.longValue());
        }
        if (this.completionTime != null) {
            generator.writeKey("completion_time");
            generator.write(this.completionTime);
        }
        if (this.completionTimeMillis != null) {
            generator.writeKey("completion_time_millis");
            generator.write(this.completionTimeMillis.longValue());
        }
        if (this.masterApplyTime != null) {
            generator.writeKey("master_apply_time");
            generator.write(this.masterApplyTime);
        }
        if (this.masterApplyTimeMillis != null) {
            generator.writeKey("master_apply_time_millis");
            generator.write(this.masterApplyTimeMillis.longValue());
        }
        if (this.notificationTime != null) {
            generator.writeKey("notification_time");
            generator.write(this.notificationTime);
        }
        if (this.notificationTimeMillis != null) {
            generator.writeKey("notification_time_millis");
            generator.write(this.notificationTimeMillis.longValue());
        }
    }

    protected static void setupClusterStateUpdateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::computationTime, JsonpDeserializer.stringDeserializer(), "computation_time");
        op.add(Builder::computationTimeMillis, JsonpDeserializer.longDeserializer(), "computation_time_millis");
        op.add(Builder::publicationTime, JsonpDeserializer.stringDeserializer(), "publication_time");
        op.add(Builder::publicationTimeMillis, JsonpDeserializer.longDeserializer(), "publication_time_millis");
        op.add(Builder::contextConstructionTime, JsonpDeserializer.stringDeserializer(), "context_construction_time");
        op.add(Builder::contextConstructionTimeMillis, JsonpDeserializer.longDeserializer(), "context_construction_time_millis");
        op.add(Builder::commitTime, JsonpDeserializer.stringDeserializer(), "commit_time");
        op.add(Builder::commitTimeMillis, JsonpDeserializer.longDeserializer(), "commit_time_millis");
        op.add(Builder::completionTime, JsonpDeserializer.stringDeserializer(), "completion_time");
        op.add(Builder::completionTimeMillis, JsonpDeserializer.longDeserializer(), "completion_time_millis");
        op.add(Builder::masterApplyTime, JsonpDeserializer.stringDeserializer(), "master_apply_time");
        op.add(Builder::masterApplyTimeMillis, JsonpDeserializer.longDeserializer(), "master_apply_time_millis");
        op.add(Builder::notificationTime, JsonpDeserializer.stringDeserializer(), "notification_time");
        op.add(Builder::notificationTimeMillis, JsonpDeserializer.longDeserializer(), "notification_time_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterStateUpdate> {
        @Nullable
        private Long count;
        @Nullable
        private String computationTime;
        @Nullable
        private Long computationTimeMillis;
        @Nullable
        private String publicationTime;
        @Nullable
        private Long publicationTimeMillis;
        @Nullable
        private String contextConstructionTime;
        @Nullable
        private Long contextConstructionTimeMillis;
        @Nullable
        private String commitTime;
        @Nullable
        private Long commitTimeMillis;
        @Nullable
        private String completionTime;
        @Nullable
        private Long completionTimeMillis;
        @Nullable
        private String masterApplyTime;
        @Nullable
        private Long masterApplyTimeMillis;
        @Nullable
        private String notificationTime;
        @Nullable
        private Long notificationTimeMillis;

        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        public final Builder computationTime(@Nullable String value) {
            this.computationTime = value;
            return this;
        }

        public final Builder computationTimeMillis(@Nullable Long value) {
            this.computationTimeMillis = value;
            return this;
        }

        public final Builder publicationTime(@Nullable String value) {
            this.publicationTime = value;
            return this;
        }

        public final Builder publicationTimeMillis(@Nullable Long value) {
            this.publicationTimeMillis = value;
            return this;
        }

        public final Builder contextConstructionTime(@Nullable String value) {
            this.contextConstructionTime = value;
            return this;
        }

        public final Builder contextConstructionTimeMillis(@Nullable Long value) {
            this.contextConstructionTimeMillis = value;
            return this;
        }

        public final Builder commitTime(@Nullable String value) {
            this.commitTime = value;
            return this;
        }

        public final Builder commitTimeMillis(@Nullable Long value) {
            this.commitTimeMillis = value;
            return this;
        }

        public final Builder completionTime(@Nullable String value) {
            this.completionTime = value;
            return this;
        }

        public final Builder completionTimeMillis(@Nullable Long value) {
            this.completionTimeMillis = value;
            return this;
        }

        public final Builder masterApplyTime(@Nullable String value) {
            this.masterApplyTime = value;
            return this;
        }

        public final Builder masterApplyTimeMillis(@Nullable Long value) {
            this.masterApplyTimeMillis = value;
            return this;
        }

        public final Builder notificationTime(@Nullable String value) {
            this.notificationTime = value;
            return this;
        }

        public final Builder notificationTimeMillis(@Nullable Long value) {
            this.notificationTimeMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterStateUpdate build() {
            this._checkSingleUse();
            return new ClusterStateUpdate(this);
        }
    }
}

