/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Context
implements JsonpSerializable {
    @Nullable
    private final String context;
    @Nullable
    private final Long compilations;
    @Nullable
    private final Long cacheEvictions;
    @Nullable
    private final Long compilationLimitTriggered;
    public static final JsonpDeserializer<Context> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Context::setupContextDeserializer);

    private Context(Builder builder) {
        this.context = builder.context;
        this.compilations = builder.compilations;
        this.cacheEvictions = builder.cacheEvictions;
        this.compilationLimitTriggered = builder.compilationLimitTriggered;
    }

    public static Context of(Function<Builder, ObjectBuilder<Context>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String context() {
        return this.context;
    }

    @Nullable
    public final Long compilations() {
        return this.compilations;
    }

    @Nullable
    public final Long cacheEvictions() {
        return this.cacheEvictions;
    }

    @Nullable
    public final Long compilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.context != null) {
            generator.writeKey("context");
            generator.write(this.context);
        }
        if (this.compilations != null) {
            generator.writeKey("compilations");
            generator.write(this.compilations.longValue());
        }
        if (this.cacheEvictions != null) {
            generator.writeKey("cache_evictions");
            generator.write(this.cacheEvictions.longValue());
        }
        if (this.compilationLimitTriggered != null) {
            generator.writeKey("compilation_limit_triggered");
            generator.write(this.compilationLimitTriggered.longValue());
        }
    }

    protected static void setupContextDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::context, JsonpDeserializer.stringDeserializer(), "context");
        op.add(Builder::compilations, JsonpDeserializer.longDeserializer(), "compilations");
        op.add(Builder::cacheEvictions, JsonpDeserializer.longDeserializer(), "cache_evictions");
        op.add(Builder::compilationLimitTriggered, JsonpDeserializer.longDeserializer(), "compilation_limit_triggered");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Context> {
        @Nullable
        private String context;
        @Nullable
        private Long compilations;
        @Nullable
        private Long cacheEvictions;
        @Nullable
        private Long compilationLimitTriggered;

        public final Builder context(@Nullable String value) {
            this.context = value;
            return this;
        }

        public final Builder compilations(@Nullable Long value) {
            this.compilations = value;
            return this;
        }

        public final Builder cacheEvictions(@Nullable Long value) {
            this.cacheEvictions = value;
            return this;
        }

        public final Builder compilationLimitTriggered(@Nullable Long value) {
            this.compilationLimitTriggered = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Context build() {
            this._checkSingleUse();
            return new Context(this);
        }
    }
}

