/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown.get_node;

import co.elastic.clients.elasticsearch.shutdown.get_node.PersistentTaskStatus;
import co.elastic.clients.elasticsearch.shutdown.get_node.PluginsStatus;
import co.elastic.clients.elasticsearch.shutdown.get_node.ShardMigrationStatus;
import co.elastic.clients.elasticsearch.shutdown.get_node.ShutdownStatus;
import co.elastic.clients.elasticsearch.shutdown.get_node.ShutdownType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NodeShutdownStatus
implements JsonpSerializable {
    private final String nodeId;
    private final ShutdownType type;
    private final String reason;
    private final DateTime shutdownStartedmillis;
    private final ShutdownStatus status;
    private final ShardMigrationStatus shardMigration;
    private final PersistentTaskStatus persistentTasks;
    private final PluginsStatus plugins;
    public static final JsonpDeserializer<NodeShutdownStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeShutdownStatus::setupNodeShutdownStatusDeserializer);

    private NodeShutdownStatus(Builder builder) {
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.shutdownStartedmillis = ApiTypeHelper.requireNonNull(builder.shutdownStartedmillis, this, "shutdownStartedmillis");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.shardMigration = ApiTypeHelper.requireNonNull(builder.shardMigration, this, "shardMigration");
        this.persistentTasks = ApiTypeHelper.requireNonNull(builder.persistentTasks, this, "persistentTasks");
        this.plugins = ApiTypeHelper.requireNonNull(builder.plugins, this, "plugins");
    }

    public static NodeShutdownStatus of(Function<Builder, ObjectBuilder<NodeShutdownStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final ShutdownType type() {
        return this.type;
    }

    public final String reason() {
        return this.reason;
    }

    public final DateTime shutdownStartedmillis() {
        return this.shutdownStartedmillis;
    }

    public final ShutdownStatus status() {
        return this.status;
    }

    public final ShardMigrationStatus shardMigration() {
        return this.shardMigration;
    }

    public final PersistentTaskStatus persistentTasks() {
        return this.persistentTasks;
    }

    public final PluginsStatus plugins() {
        return this.plugins;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("shutdown_startedmillis");
        this.shutdownStartedmillis.serialize(generator, mapper);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("shard_migration");
        this.shardMigration.serialize(generator, mapper);
        generator.writeKey("persistent_tasks");
        this.persistentTasks.serialize(generator, mapper);
        generator.writeKey("plugins");
        this.plugins.serialize(generator, mapper);
    }

    protected static void setupNodeShutdownStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::type, ShutdownType._DESERIALIZER, "type");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::shutdownStartedmillis, DateTime._DESERIALIZER, "shutdown_startedmillis");
        op.add(Builder::status, ShutdownStatus._DESERIALIZER, "status");
        op.add(Builder::shardMigration, ShardMigrationStatus._DESERIALIZER, "shard_migration");
        op.add(Builder::persistentTasks, PersistentTaskStatus._DESERIALIZER, "persistent_tasks");
        op.add(Builder::plugins, PluginsStatus._DESERIALIZER, "plugins");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeShutdownStatus> {
        private String nodeId;
        private ShutdownType type;
        private String reason;
        private DateTime shutdownStartedmillis;
        private ShutdownStatus status;
        private ShardMigrationStatus shardMigration;
        private PersistentTaskStatus persistentTasks;
        private PluginsStatus plugins;

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder type(ShutdownType value) {
            this.type = value;
            return this;
        }

        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public final Builder shutdownStartedmillis(DateTime value) {
            this.shutdownStartedmillis = value;
            return this;
        }

        public final Builder status(ShutdownStatus value) {
            this.status = value;
            return this;
        }

        public final Builder shardMigration(ShardMigrationStatus value) {
            this.shardMigration = value;
            return this;
        }

        public final Builder shardMigration(Function<ShardMigrationStatus.Builder, ObjectBuilder<ShardMigrationStatus>> fn) {
            return this.shardMigration(fn.apply(new ShardMigrationStatus.Builder()).build());
        }

        public final Builder persistentTasks(PersistentTaskStatus value) {
            this.persistentTasks = value;
            return this;
        }

        public final Builder persistentTasks(Function<PersistentTaskStatus.Builder, ObjectBuilder<PersistentTaskStatus>> fn) {
            return this.persistentTasks(fn.apply(new PersistentTaskStatus.Builder()).build());
        }

        public final Builder plugins(PluginsStatus value) {
            this.plugins = value;
            return this;
        }

        public final Builder plugins(Function<PluginsStatus.Builder, ObjectBuilder<PluginsStatus>> fn) {
            return this.plugins(fn.apply(new PluginsStatus.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeShutdownStatus build() {
            this._checkSingleUse();
            return new NodeShutdownStatus(this);
        }
    }
}

