/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch.tasks.TaskInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeTasks
implements JsonpSerializable {
    @Nullable
    private final String name;
    @Nullable
    private final String transportAddress;
    @Nullable
    private final String host;
    @Nullable
    private final String ip;
    private final List<String> roles;
    private final Map<String, String> attributes;
    private final Map<String, TaskInfo> tasks;
    public static final JsonpDeserializer<NodeTasks> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeTasks::setupNodeTasksDeserializer);

    private NodeTasks(Builder builder) {
        this.name = builder.name;
        this.transportAddress = builder.transportAddress;
        this.host = builder.host;
        this.ip = builder.ip;
        this.roles = ApiTypeHelper.unmodifiable(builder.roles);
        this.attributes = ApiTypeHelper.unmodifiable(builder.attributes);
        this.tasks = ApiTypeHelper.unmodifiableRequired(builder.tasks, (Object)this, "tasks");
    }

    public static NodeTasks of(Function<Builder, ObjectBuilder<NodeTasks>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final String transportAddress() {
        return this.transportAddress;
    }

    @Nullable
    public final String host() {
        return this.host;
    }

    @Nullable
    public final String ip() {
        return this.ip;
    }

    public final List<String> roles() {
        return this.roles;
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final Map<String, TaskInfo> tasks() {
        return this.tasks;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.transportAddress != null) {
            generator.writeKey("transport_address");
            generator.write(this.transportAddress);
        }
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.ip != null) {
            generator.writeKey("ip");
            generator.write(this.ip);
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry entry : this.attributes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.tasks)) {
            generator.writeKey("tasks");
            generator.writeStartObject();
            for (Map.Entry entry : this.tasks.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((TaskInfo)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupNodeTasksDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::ip, JsonpDeserializer.stringDeserializer(), "ip");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::tasks, JsonpDeserializer.stringMapDeserializer(TaskInfo._DESERIALIZER), "tasks");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeTasks> {
        @Nullable
        private String name;
        @Nullable
        private String transportAddress;
        @Nullable
        private String host;
        @Nullable
        private String ip;
        @Nullable
        private List<String> roles;
        @Nullable
        private Map<String, String> attributes;
        private Map<String, TaskInfo> tasks;

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder transportAddress(@Nullable String value) {
            this.transportAddress = value;
            return this;
        }

        public final Builder host(@Nullable String value) {
            this.host = value;
            return this;
        }

        public final Builder ip(@Nullable String value) {
            this.ip = value;
            return this;
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder tasks(Map<String, TaskInfo> map) {
            this.tasks = Builder._mapPutAll(this.tasks, map);
            return this;
        }

        public final Builder tasks(String key, TaskInfo value) {
            this.tasks = Builder._mapPut(this.tasks, key, value);
            return this;
        }

        public final Builder tasks(String key, Function<TaskInfo.Builder, ObjectBuilder<TaskInfo>> fn) {
            return this.tasks(key, fn.apply(new TaskInfo.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeTasks build() {
            this._checkSingleUse();
            return new NodeTasks(this);
        }
    }
}

