/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport;

import co.elastic.clients.ApiClient;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;

public class Version {
    private final int major;
    private final int minor;
    private final int maintenance;
    private final boolean isPreRelease;
    @Nullable
    public static final Version VERSION;

    public static Version parse(String version) {
        boolean isPreRelease;
        int hyphen = version.indexOf(45);
        if (hyphen >= 0) {
            version = version.substring(0, hyphen);
            isPreRelease = true;
        } else {
            isPreRelease = false;
        }
        String[] bits = version.split("\\.");
        try {
            int major = bits.length >= 1 ? Integer.parseInt(bits[0]) : 0;
            int minor = bits.length >= 2 ? Integer.parseInt(bits[1]) : 0;
            int maintenance = bits.length >= 3 ? Integer.parseInt(bits[2]) : -1;
            return new Version(major, minor, maintenance, isPreRelease);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Version(int major, int minor, int maintenance, boolean isPreRelease) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.isPreRelease = isPreRelease;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int maintenance() {
        return this.maintenance;
    }

    public boolean isPreRelease() {
        return this.isPreRelease;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version that = (Version)other;
        return this.major == that.major && this.minor == that.minor && this.maintenance == that.maintenance && this.isPreRelease == that.isPreRelease;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.maintenance, this.isPreRelease);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.major);
        s.append('.');
        s.append(this.minor);
        if (this.maintenance != -1) {
            s.append('.');
            s.append(this.maintenance);
        }
        if (this.isPreRelease) {
            s.append('p');
        }
        return s.toString();
    }

    static {
        Version version = null;
        InputStream in = ApiClient.class.getResourceAsStream("version.properties");
        if (in != null) {
            Properties properties = new Properties();
            try {
                properties.load(in);
                String versionStr = properties.getProperty("version");
                if (versionStr != null) {
                    version = Version.parse(versionStr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        VERSION = version;
    }
}

