/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.client;

import com.agentsflex.core.llm.client.OkHttpClientUtil;
import com.agentsflex.core.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClient.class);
    private static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient okHttpClient;

    public HttpClient() {
        this(OkHttpClientUtil.buildDefaultClient());
    }

    public HttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public String get(String url) {
        return this.executeString(url, "GET", null, null);
    }

    public byte[] getBytes(String url) {
        return this.executeBytes(url, "GET", null, null);
    }

    public String get(String url, Map<String, String> headers) {
        return this.executeString(url, "GET", headers, null);
    }

    public String post(String url, Map<String, String> headers, String payload) {
        return this.executeString(url, "POST", headers, payload);
    }

    public byte[] postBytes(String url, Map<String, String> headers, String payload) {
        return this.executeBytes(url, "POST", headers, payload);
    }

    public String put(String url, Map<String, String> headers, String payload) {
        return this.executeString(url, "PUT", headers, payload);
    }

    public String delete(String url, Map<String, String> headers, String payload) {
        return this.executeString(url, "DELETE", headers, payload);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String multipartString(String url, Map<String, String> headers, Map<String, Object> payload) {
        try (Response response = this.multipart(url, headers, payload);
             ResponseBody body = response.body();){
            if (body == null) return null;
            String string = body.string();
            return string;
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] multipartBytes(String url, Map<String, String> headers, Map<String, Object> payload) {
        try (Response response = this.multipart(url, headers, payload);
             ResponseBody body = response.body();){
            if (body == null) return null;
            byte[] byArray = body.bytes();
            return byArray;
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        return null;
    }

    public Response multipart(String url, Map<String, String> headers, Map<String, Object> payload) throws IOException {
        Request.Builder builder = new Request.Builder().url(url);
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        MultipartBody.Builder mbBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        payload.forEach((s, o) -> {
            if (o instanceof File) {
                File f = (File)o;
                RequestBody body = RequestBody.create((File)f, (MediaType)MediaType.parse((String)"application/octet-stream"));
                mbBuilder.addFormDataPart(s, f.getName(), body);
            } else if (o instanceof InputStream) {
                InputStreamRequestBody body = new InputStreamRequestBody(MediaType.parse((String)"application/octet-stream"), (InputStream)o);
                mbBuilder.addFormDataPart(s, s, (RequestBody)body);
            } else if (o instanceof byte[]) {
                mbBuilder.addFormDataPart(s, s, RequestBody.create((byte[])((byte[])o)));
            } else {
                mbBuilder.addFormDataPart(s, String.valueOf(o));
            }
        });
        MultipartBody multipartBody = mbBuilder.build();
        Request request = builder.post((RequestBody)multipartBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeString(String url, String method, Map<String, String> headers, String payload) {
        try (Response response = this.execute0(url, method, headers, payload);
             ResponseBody body = response.body();){
            if (body == null) return null;
            String string = body.string();
            return string;
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] executeBytes(String url, String method, Map<String, String> headers, String payload) {
        try (Response response = this.execute0(url, method, headers, payload);
             ResponseBody body = response.body();){
            if (body == null) return null;
            byte[] byArray = body.bytes();
            return byArray;
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        return null;
    }

    private Response execute0(String url, String method, Map<String, String> headers, String payload) throws IOException {
        Request request;
        Request.Builder builder = new Request.Builder().url(url);
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        if ("GET".equalsIgnoreCase(method)) {
            request = builder.method(method, null).build();
        } else {
            RequestBody body = RequestBody.create((String)payload, (MediaType)JSON_TYPE);
            request = builder.method(method, body).build();
        }
        return this.okHttpClient.newCall(request).execute();
    }

    public static class InputStreamRequestBody
    extends RequestBody {
        private final InputStream inputStream;
        private final MediaType contentType;

        public InputStreamRequestBody(MediaType contentType, InputStream inputStream) {
            if (inputStream == null) {
                throw new NullPointerException("inputStream == null");
            }
            this.contentType = contentType;
            this.inputStream = inputStream;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() throws IOException {
            return this.inputStream.available() == 0 ? -1L : (long)this.inputStream.available();
        }

        public void writeTo(@NotNull BufferedSink sink) throws IOException {
            IOUtil.copy(this.inputStream, sink);
        }
    }
}

