/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.store;

import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.util.Metadata;
import com.agentsflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StoreOptions
extends Metadata {
    public static final StoreOptions DEFAULT = new StoreOptions(){

        @Override
        public void setCollectionName(String collectionName) {
            throw new IllegalStateException("Can not set collectionName to the default instance.");
        }

        @Override
        public void setPartitionNames(List<String> partitionNames) {
            throw new IllegalStateException("Can not set partitionName to the default instance.");
        }

        @Override
        public void setEmbeddingOptions(EmbeddingOptions embeddingOptions) {
            throw new IllegalStateException("Can not set embeddingOptions to the default instance.");
        }
    };
    private String collectionName;
    private String indexName;
    private List<String> partitionNames;
    private EmbeddingOptions embeddingOptions = EmbeddingOptions.DEFAULT;

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getCollectionNameOrDefault(String other) {
        return StringUtil.hasText(this.collectionName) ? this.collectionName : other;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public String getPartitionName() {
        return this.partitionNames != null && !this.partitionNames.isEmpty() ? this.partitionNames.get(0) : null;
    }

    public List<String> getPartitionNamesOrEmpty() {
        return this.partitionNames == null ? Collections.emptyList() : this.partitionNames;
    }

    public void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    public StoreOptions partitionName(String partitionName) {
        if (this.partitionNames == null) {
            this.partitionNames = new ArrayList<String>(1);
        }
        this.partitionNames.add(partitionName);
        return this;
    }

    public EmbeddingOptions getEmbeddingOptions() {
        return this.embeddingOptions;
    }

    public void setEmbeddingOptions(EmbeddingOptions embeddingOptions) {
        this.embeddingOptions = embeddingOptions;
    }

    public static StoreOptions ofCollectionName(String collectionName) {
        StoreOptions storeOptions = new StoreOptions();
        storeOptions.setCollectionName(collectionName);
        return storeOptions;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexNameOrDefault(String other) {
        return StringUtil.hasText(this.indexName) ? this.indexName : other;
    }
}

