/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.document.splitter;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.document.DocumentSplitter;
import com.agentsflex.core.document.id.DocumentIdGenerator;
import com.agentsflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RegexDocumentSplitter
implements DocumentSplitter {
    private final String regex;

    public RegexDocumentSplitter(String regex) {
        this.regex = regex;
    }

    @Override
    public List<Document> split(Document document, DocumentIdGenerator idGenerator) {
        if (document == null || StringUtil.noText(document.getContent())) {
            return Collections.emptyList();
        }
        String[] textArray = document.getContent().split(this.regex);
        ArrayList<Document> chunks = new ArrayList<Document>(textArray.length);
        for (String textString : textArray) {
            if (StringUtil.noText(textString)) continue;
            Document newDocument = new Document();
            newDocument.addMetadata(document.getMetadataMap());
            newDocument.setContent(textString);
            newDocument.setId(idGenerator == null ? null : idGenerator.generateId(newDocument));
            chunks.add(newDocument);
        }
        return chunks;
    }
}

