/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.response;

import com.agentsflex.core.llm.functions.Function;
import com.agentsflex.core.llm.response.AbstractBaseMessageResponse;
import com.agentsflex.core.llm.response.FunctionCaller;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.FunctionCall;
import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AiMessageResponse
extends AbstractBaseMessageResponse<AiMessage> {
    private Prompt prompt;
    private String response;
    private AiMessage message;

    public AiMessageResponse(Prompt prompt, String response, AiMessage message) {
        this.prompt = prompt;
        this.response = response;
        this.message = message;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    @Override
    public AiMessage getMessage() {
        return this.message;
    }

    public void setMessage(AiMessage message) {
        this.message = message;
    }

    public boolean isFunctionCall() {
        if (this.message == null) {
            return false;
        }
        List<FunctionCall> calls = this.message.getCalls();
        return calls != null && !calls.isEmpty();
    }

    public List<FunctionCaller> getFunctionCallers() {
        if (this.message == null) {
            return Collections.emptyList();
        }
        List<FunctionCall> calls = this.message.getCalls();
        if (calls == null || calls.isEmpty()) {
            return Collections.emptyList();
        }
        HumanMessage humanMessage = (HumanMessage)CollectionUtil.lastItem(this.prompt.toMessages());
        Map<String, Function> funcMap = humanMessage.getFunctionMap();
        if (funcMap == null || funcMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FunctionCaller> functionCallers = new ArrayList<FunctionCaller>(calls.size());
        for (FunctionCall call : calls) {
            Function function = funcMap.get(call.getName());
            if (function == null) continue;
            functionCallers.add(new FunctionCaller(function, call));
        }
        return functionCallers;
    }

    public List<Object> callFunctions() {
        List<FunctionCaller> functionCallers = this.getFunctionCallers();
        if (CollectionUtil.noItems(functionCallers)) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (FunctionCaller functionCaller : functionCallers) {
            results.add(functionCaller.call());
        }
        return results;
    }

    public static AiMessageResponse error(Prompt prompt, String response, String errorMessage) {
        AiMessageResponse errorResp = new AiMessageResponse(prompt, response, null);
        errorResp.setError(true);
        errorResp.setErrorMessage(errorMessage);
        return errorResp;
    }

    public String toString() {
        return "AiMessageResponse{prompt=" + this.prompt + ", response='" + this.response + '\'' + ", message=" + this.message + ", error=" + this.error + ", errorMessage='" + this.errorMessage + '\'' + ", errorType='" + this.errorType + '\'' + ", errorCode='" + this.errorCode + '\'' + '}';
    }
}

