/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.prompt;

import com.agentsflex.core.message.HumanAudioMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.prompt.TextPrompt;
import com.agentsflex.core.util.StringUtil;
import java.util.Collections;
import java.util.List;

public class AudioPrompt
extends TextPrompt {
    private String audioUrl;

    public AudioPrompt(String content) {
        super(content);
    }

    public AudioPrompt(String content, String audioUrl) {
        super(content);
        this.audioUrl = audioUrl;
    }

    public String getAudioUrl() {
        return this.audioUrl;
    }

    public void setAudioUrl(String audioUrl) {
        this.audioUrl = audioUrl;
    }

    public String toUrl() {
        if (StringUtil.hasText(this.audioUrl)) {
            return this.audioUrl;
        }
        return null;
    }

    @Override
    public List<Message> toMessages() {
        return Collections.singletonList(new HumanAudioMessage(this));
    }

    @Override
    public String toString() {
        return "AudioPrompt{audioUrl='" + this.audioUrl + '\'' + ", content='" + this.content + '\'' + ", metadataMap=" + this.metadataMap + '}';
    }
}

