/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.util.graalvm;

import com.agentsflex.core.util.graalvm.ProxyList;
import com.agentsflex.core.util.graalvm.ProxyMap;
import java.lang.reflect.Array;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public class JsInteropUtils {
    public static Value wrapJavaValueForJS(Context context, Object value) {
        if (value == null) {
            return context.asValue(null);
        }
        if (value instanceof LocalDateTime) {
            return context.eval("js", (CharSequence)("new Date('" + ((LocalDateTime)value).atZone(ZoneId.systemDefault()) + "')"));
        }
        if (value instanceof LocalDate) {
            return context.eval("js", (CharSequence)("new Date('" + ((LocalDate)value).atStartOfDay(ZoneId.systemDefault()) + "')"));
        }
        if (value instanceof ZonedDateTime) {
            return context.eval("js", (CharSequence)("new Date('" + value + "')"));
        }
        if (value instanceof Date) {
            return context.eval("js", (CharSequence)("new Date(" + ((Date)value).getTime() + ")"));
        }
        if (value instanceof Map) {
            return context.asValue((Object)new ProxyMap((Map)value, context));
        }
        if (value instanceof List) {
            return context.asValue((Object)new ProxyList((List)value, context));
        }
        if (value instanceof Set) {
            return context.asValue((Object)new ProxyList(new ArrayList<Object>((Set)value), context));
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            List<Object> list = IntStream.range(0, length).mapToObj(i -> Array.get(value, i)).collect(Collectors.toList());
            return context.asValue((Object)new ProxyList(list, context));
        }
        return context.asValue(value);
    }

    public static Object unwrapJsValue(Value value) {
        if (value.isHostObject()) {
            return value.asHostObject();
        }
        if (value.hasMembers()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : value.getMemberKeys()) {
                map.put(key, JsInteropUtils.unwrapJsValue(value.getMember(key)));
            }
            return map;
        }
        if (value.hasArrayElements()) {
            ArrayList<Object> list = new ArrayList<Object>();
            long size = value.getArraySize();
            for (long i = 0L; i < size; ++i) {
                list.add(JsInteropUtils.unwrapJsValue(value.getArrayElement(i)));
            }
            return list;
        }
        if (value.isDate()) {
            Instant instant = Instant.from(value.asDate());
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        return value.as(Object.class);
    }
}

