/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.image.siliconflow;

import com.agentsflex.core.image.EditImageRequest;
import com.agentsflex.core.image.GenerateImageRequest;
import com.agentsflex.core.image.ImageModel;
import com.agentsflex.core.image.ImageResponse;
import com.agentsflex.core.image.VaryImageRequest;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.image.siliconflow.SiliconflowImageModelConfig;
import com.agentsflex.image.siliconflow.SiliconflowImageModels;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;

public class SiliconImageModel
implements ImageModel {
    private SiliconflowImageModelConfig config;
    private HttpClient httpClient = new HttpClient();

    public SiliconImageModel(SiliconflowImageModelConfig config) {
        this.config = config;
    }

    public ImageResponse generate(GenerateImageRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + this.config.getApiKey());
        String payload = Maps.of((String)"prompt", (Object)request.getPrompt()).setIfNotEmpty("negative_prompt", (Object)request.getNegativePrompt()).setOrDefault("image_size", (Object)request.getSize(), (Object)this.config.getImageSize()).setOrDefault("batch_size", (Object)request.getN(), (Object)1).setOrDefault("num_inference_steps", request.getOption("num_inference_steps"), (Object)this.config.getNumInferenceSteps()).setOrDefault("guidance_scale", request.getOption("guidance_scale"), (Object)this.config.getGuidanceScale()).toJSON();
        String url = this.config.getEndpoint() + SiliconflowImageModels.getPath(this.config.getModel());
        String response = this.httpClient.post(url, headers, payload);
        if (StringUtil.noText((String)response)) {
            return ImageResponse.error((String)"response is no text");
        }
        if (StringUtil.notJsonObject((String)response)) {
            return ImageResponse.error((String)response);
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONArray imagesArray = jsonObject.getJSONArray("images");
        if (imagesArray == null || imagesArray.isEmpty()) {
            return null;
        }
        ImageResponse imageResponse = new ImageResponse();
        for (int i = 0; i < imagesArray.size(); ++i) {
            JSONObject imageObject = imagesArray.getJSONObject(i);
            imageResponse.addImage(imageObject.getString("url"));
        }
        return imageResponse;
    }

    public ImageResponse img2imggenerate(GenerateImageRequest request) {
        return null;
    }

    public ImageResponse edit(EditImageRequest request) {
        throw new IllegalStateException("SiliconImageModel Can not support edit image.");
    }

    public ImageResponse vary(VaryImageRequest request) {
        throw new IllegalStateException("SiliconImageModel Can not support vary image.");
    }
}

