/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.spark;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.functions.Function;
import com.agentsflex.core.functions.Parameter;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.message.MessageStatus;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.FunctionMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.parser.impl.DefaultFunctionMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.HashUtil;
import com.agentsflex.core.util.Maps;
import com.agentsflex.llm.spark.SparkLlmConfig;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class SparkLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat(){

        protected void buildFunctionJsonArray(List<Map<String, Object>> functionsJsonArray, List<Function> functions) {
            for (Function function : functions) {
                HashMap<String, Map> propertiesMap = new HashMap<String, Map>();
                ArrayList<String> requiredProperties = new ArrayList<String>();
                Parameter[] parameters = function.getParameters();
                if (parameters != null) {
                    for (Parameter parameter : parameters) {
                        if (parameter.isRequired()) {
                            requiredProperties.add(parameter.getName());
                        }
                        propertiesMap.put(parameter.getName(), Maps.of((String)"type", (Object)parameter.getType()).put("description", (Object)parameter.getDescription()).build());
                    }
                }
                Maps.Builder builder = Maps.of((String)"name", (Object)function.getName()).put("description", (Object)function.getDescription()).put("parameters", Maps.of((String)"type", (Object)"object").put("properties", propertiesMap).put("required", requiredProperties));
                functionsJsonArray.add(builder.build());
            }
        }
    };

    public static AiMessageParser getAiMessageParser() {
        DefaultAiMessageParser aiMessageParser = new DefaultAiMessageParser();
        aiMessageParser.setContentPath("$.payload.choices.text[0].content");
        aiMessageParser.setIndexPath("$.payload.choices.text[0].index");
        aiMessageParser.setStatusPath("$.payload.choices.status");
        aiMessageParser.setCompletionTokensPath("$.payload.usage.text.completion_tokens");
        aiMessageParser.setPromptTokensPath("$.payload.usage.text.prompt_tokens");
        aiMessageParser.setTotalTokensPath("$.payload.usage.text.total_tokens");
        aiMessageParser.setStatusParser(content -> SparkLlmUtil.parseMessageStatus((Integer)content));
        return aiMessageParser;
    }

    public static FunctionMessageParser getFunctionMessageParser() {
        DefaultFunctionMessageParser functionMessageParser = new DefaultFunctionMessageParser();
        functionMessageParser.setFunctionNamePath("$.payload.choices.text[0].function_call.name");
        functionMessageParser.setFunctionArgsPath("$.payload.choices.text[0].function_call.arguments");
        functionMessageParser.setFunctionArgsParser(JSON::parseObject);
        return functionMessageParser;
    }

    public static String promptToPayload(Prompt prompt, SparkLlmConfig config, ChatOptions options) {
        Maps.Builder root = Maps.of((String)"header", (Maps.Builder)Maps.of((String)"app_id", (Object)config.getAppId()).put("uid", (Object)UUID.randomUUID()));
        root.put("parameter", Maps.of((String)"chat", (Maps.Builder)Maps.of((String)"domain", (Object)SparkLlmUtil.getDomain(config.getVersion())).putIf(options.getTemperature().floatValue() > 0.0f, "temperature", (Object)options.getTemperature()).putIf(options.getMaxTokens() != null, "max_tokens", (Object)options.getMaxTokens()).putIfNotNull("top_k", (Object)options.getTopK())));
        root.put("payload", Maps.of((String)"message", (Maps.Builder)Maps.of((String)"text", (Object)promptFormat.toMessagesJsonObject(prompt))).putIfNotEmpty("functions", Maps.ofNotNull((String)"text", (Object)promptFormat.toFunctionsJsonObject(prompt))));
        return JSON.toJSONString((Object)root.build());
    }

    public static MessageStatus parseMessageStatus(Integer status) {
        if (status == null) {
            return MessageStatus.UNKNOW;
        }
        switch (status) {
            case 0: {
                return MessageStatus.START;
            }
            case 1: {
                return MessageStatus.MIDDLE;
            }
            case 2: {
                return MessageStatus.END;
            }
        }
        return MessageStatus.UNKNOW;
    }

    public static String createURL(SparkLlmConfig config) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss '+0000'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = sdf.format(new Date());
        String header = "host: spark-api.xf-yun.com\n";
        header = header + "date: " + date + "\n";
        header = header + "GET /" + config.getVersion() + "/chat HTTP/1.1";
        String base64 = HashUtil.hmacSHA256ToBase64((String)header, (String)config.getApiSecret());
        String authorization_origin = "api_key=\"" + config.getApiKey() + "\", algorithm=\"hmac-sha256\", headers=\"host date request-line\", signature=\"" + base64 + "\"";
        String authorization = Base64.getEncoder().encodeToString(authorization_origin.getBytes());
        return "ws://spark-api.xf-yun.com/" + config.getVersion() + "/chat?authorization=" + authorization + "&date=" + SparkLlmUtil.urlEncode(date) + "&host=spark-api.xf-yun.com";
    }

    private static String urlEncode(String content) {
        try {
            return URLEncoder.encode(content, "utf-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getDomain(String version) {
        switch (version) {
            case "v3.5": {
                return "generalv3.5";
            }
            case "v3.1": {
                return "generalv3";
            }
            case "v2.1": {
                return "generalv2";
            }
        }
        return "general";
    }

    public static String embedPayload(SparkLlmConfig config, Document document) {
        String text = Maps.of((String)"messages", Collections.singletonList(Maps.of((String)"content", (Object)document.getContent()).put("role", (Object)"user").build())).toJSON();
        String textBase64 = Base64.getEncoder().encodeToString(text.getBytes());
        return Maps.of((String)"header", (Maps.Builder)Maps.of((String)"app_id", (Object)config.getAppId()).put("uid", (Object)UUID.randomUUID()).put("status", (Object)3)).put("parameter", Maps.of((String)"emb", (Maps.Builder)Maps.of((String)"domain", (Object)"para").put("feature", Maps.of((String)"encoding", (Object)"utf8").put("compress", (Object)"raw").put("format", (Object)"plain")))).put("payload", Maps.of((String)"messages", (Maps.Builder)Maps.of((String)"encoding", (Object)"utf8").put("compress", (Object)"raw").put("format", (Object)"json").put("status", (Object)3).put("text", (Object)textBase64))).toJSON();
    }

    public static String createEmbedURL(SparkLlmConfig config) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss '+0000'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = sdf.format(new Date());
        String header = "host: emb-cn-huabei-1.xf-yun.com\n";
        header = header + "date: " + date + "\n";
        header = header + "POST / HTTP/1.1";
        String base64 = HashUtil.hmacSHA256ToBase64((String)header, (String)config.getApiSecret());
        String authorization_origin = "api_key=\"" + config.getApiKey() + "\", algorithm=\"hmac-sha256\", headers=\"host date request-line\", signature=\"" + base64 + "\"";
        String authorization = Base64.getEncoder().encodeToString(authorization_origin.getBytes());
        return "http://emb-cn-huabei-1.xf-yun.com/?authorization=" + authorization + "&date=" + SparkLlmUtil.urlEncode(date) + "&host=emb-cn-huabei-1.xf-yun.com";
    }
}

