/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.volcengine;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.volcengine.VolcengineLlmConfig;
import com.agentsflex.llm.volcengine.VolcengineLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class VolcengineLlm
extends BaseLlm<VolcengineLlmConfig> {
    private final HttpClient httpClient = new HttpClient();
    public AiMessageParser aiMessageParser = VolcengineLlmUtil.getAiMessageParser(false);
    public AiMessageParser streamMessageParser = VolcengineLlmUtil.getAiMessageParser(true);

    private Map<String, String> buildHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((VolcengineLlmConfig)this.config).getApiKey());
        return headers;
    }

    public VolcengineLlm(VolcengineLlmConfig config) {
        super((LlmConfig)config);
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        Map<String, String> headers = this.buildHeader();
        Consumer headersConfig = ((VolcengineLlmConfig)this.config).getHeadersConfig();
        if (headersConfig != null) {
            headersConfig.accept(headers);
        }
        String payload = VolcengineLlmUtil.promptToPayload(prompt, (VolcengineLlmConfig)this.config, options, false);
        String endpoint = ((VolcengineLlmConfig)this.config).getEndpoint();
        String defaultChatApi = ((VolcengineLlmConfig)this.config).getDefaultChatApi();
        String response = this.httpClient.post(endpoint + defaultChatApi, headers, payload);
        if (((VolcengineLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("error");
        AiMessageResponse messageResponse = new AiMessageResponse(prompt, response, (AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("code"));
        }
        return messageResponse;
    }

    public void chatStream(Prompt prompt, StreamResponseListener listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        Map<String, String> headers = this.buildHeader();
        String payload = VolcengineLlmUtil.promptToPayload(prompt, (VolcengineLlmConfig)this.config, options, true);
        String endpoint = ((VolcengineLlmConfig)this.config).getEndpoint();
        String defaultChatApi = ((VolcengineLlmConfig)this.config).getDefaultChatApi();
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, this.streamMessageParser);
        llmClient.start(endpoint + defaultChatApi, headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        return null;
    }
}

