/*
 * 爱组搭 http://aizuda.com 低代码组件化开发平台
 * ------------------------------------------
 * 受知识产权保护，请勿删除版权申明
 */
package com.aizuda.common.toolkit;

import java.util.regex.Pattern;

/**
 * 正则表达式判断工具类
 * <p>
 * 尊重知识产权，CV 请保留版权，爱组搭 http://aizuda.com 出品
 *
 * @author 青苗
 * @since 2022-03-18
 */
public class RegexUtils {

    /**
     * 电子邮箱
     */
    public static String EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";

    /**
     * 判断是否为6-20位字母数字密码
     *
     * @param password 密码
     * @return
     */
    public static boolean isPassword(String password) {
        return isAlphanumericSymbols(password, 6, 20);
    }

    /**
     * 判断字符串是否为字母数字混合
     *
     * @param input 待判断字符串
     * @param min   最小长度
     * @param max   最大长度
     * @return
     */
    public static boolean isAlphanumericSymbols(CharSequence input, int min, int max) {
        StringBuffer pwd = new StringBuffer();
        pwd.append("^(?=.*[0-9])(?=.*[A-Z])(?=.*[a-z])(?=.*[!@#$%^&*,\\.])[0-9a-zA-Z!@#$%^&*,\\.]{");
        pwd.append(min).append(",").append(max).append("20}$");
        return matches(pwd.toString(), input);
    }

    /**
     * 字符串正则判断
     *
     * @param regex 正则
     * @param input 待判断字符串
     * @return
     */
    public static boolean matches(String regex, CharSequence input) {
        return Pattern.matches(regex, input);
    }
}
