/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.mybatisplus.impl;

import com.aizuda.bpm.engine.dao.FlwTaskDao;
import com.aizuda.bpm.engine.entity.FlowEntity;
import com.aizuda.bpm.engine.entity.FlwTask;
import com.aizuda.bpm.mybatisplus.mapper.FlwTaskMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Date;
import java.util.List;

public class FlwTaskDaoImpl
implements FlwTaskDao {
    private final FlwTaskMapper taskMapper;

    public FlwTaskDaoImpl(FlwTaskMapper taskMapper) {
        this.taskMapper = taskMapper;
    }

    public boolean insert(FlwTask flwTask) {
        return this.taskMapper.insert(flwTask) > 0;
    }

    public boolean deleteById(Long id) {
        return this.taskMapper.deleteById(id) > 0;
    }

    public boolean deleteByInstanceIdAndParentTaskId(Long instanceId, Long parentTaskId) {
        return this.taskMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlwTask::getInstanceId, (Object)instanceId)).eq(FlwTask::getParentTaskId, (Object)parentTaskId)) > 0;
    }

    public boolean deleteByInstanceIds(List<Long> instanceIds) {
        return this.taskMapper.delete((Wrapper)Wrappers.lambdaQuery().in(FlwTask::getInstanceId, instanceIds)) > 0;
    }

    public boolean deleteByIds(List<Long> ids) {
        return this.taskMapper.delete((Wrapper)Wrappers.lambdaQuery().in(FlowEntity::getId, ids)) > 0;
    }

    public boolean updateById(FlwTask flwTask) {
        return this.taskMapper.updateById(flwTask) > 0;
    }

    public FlwTask selectById(Long id) {
        return (FlwTask)this.taskMapper.selectById(id);
    }

    public Long selectCountByParentTaskId(Long parentTaskId) {
        return this.taskMapper.selectCount((Wrapper)Wrappers.lambdaQuery().eq(FlwTask::getParentTaskId, (Object)parentTaskId));
    }

    public Long selectCountByInstanceId(Long instanceId) {
        return this.taskMapper.selectCount((Wrapper)Wrappers.lambdaQuery().eq(FlwTask::getInstanceId, (Object)instanceId));
    }

    public List<FlwTask> selectListByInstanceId(Long instanceId) {
        return this.taskMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(FlwTask::getInstanceId, (Object)instanceId));
    }

    public List<FlwTask> selectListByInstanceIdAndTaskName(Long instanceId, String taskName) {
        return this.taskMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlwTask::getInstanceId, (Object)instanceId)).eq(FlwTask::getTaskName, (Object)taskName));
    }

    public List<FlwTask> selectListByInstanceIdAndTaskKey(Long instanceId, String taskKey) {
        return this.taskMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlwTask::getInstanceId, (Object)instanceId)).eq(FlwTask::getTaskKey, (Object)taskKey));
    }

    public List<FlwTask> selectListByInstanceIdAndTaskNames(Long instanceId, List<String> taskNames) {
        return this.taskMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlwTask::getInstanceId, (Object)instanceId)).in(FlwTask::getTaskName, taskNames));
    }

    public List<FlwTask> selectListTimeoutOrRemindTasks(Date currentDate) {
        return this.taskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().le(FlwTask::getExpireTime, (Object)currentDate)).or()).le(FlwTask::getRemindTime, (Object)currentDate));
    }

    public List<FlwTask> selectListByParentTaskId(Long parentTaskId) {
        return this.taskMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(FlwTask::getParentTaskId, (Object)parentTaskId));
    }

    public List<FlwTask> selectListByParentTaskIds(List<Long> parentTaskIds) {
        return this.taskMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(FlwTask::getParentTaskId, parentTaskIds));
    }
}

