/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.log.report;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.LogReport;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.log.report.LogReportFactory;
import com.aizuda.snailjob.client.common.log.report.ReportLogListener;
import com.aizuda.snailjob.client.common.window.SlidingWindow;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.common.log.dto.LogContentDTO;
import com.aizuda.snailjob.server.model.dto.LogTaskDTO;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLogReport<T extends LogTaskDTO>
implements Lifecycle,
InitializingBean,
LogReport {
    @Autowired
    private SnailJobProperties snailJobProperties;
    private SlidingWindow<LogTaskDTO> slidingWindow;

    @Override
    public void report(LogContentDTO logContentDTO) {
        this.slidingWindow.add((LogTaskDTO)this.buildLogTaskDTO(logContentDTO));
    }

    protected abstract T buildLogTaskDTO(LogContentDTO var1);

    @Override
    public void start() {
        if (Objects.nonNull(this.slidingWindow)) {
            return;
        }
        SnailJobProperties.LogSlidingWindowConfig logSlidingWindow = this.snailJobProperties.getLogSlidingWindow();
        ReportLogListener reportLogListener = new ReportLogListener();
        this.slidingWindow = SlidingWindow.Builder.newBuilder().withTotalThreshold(logSlidingWindow.getTotalThreshold()).withWindowTotalThreshold(logSlidingWindow.getWindowTotalThreshold()).withDuration(logSlidingWindow.getDuration(), logSlidingWindow.getChronoUnit()).withListener(reportLogListener).build();
        this.slidingWindow.start();
    }

    @Override
    public void close() {
        if (Objects.isNull(this.slidingWindow)) {
            return;
        }
        SnailJobLog.LOCAL.info("AsyncReport Log about to shutdown", new Object[0]);
        this.slidingWindow.end();
        SnailJobLog.LOCAL.info("AsyncReport Log has been shutdown", new Object[0]);
    }

    public void afterPropertiesSet() throws Exception {
        LogReportFactory.add(this);
    }
}

