/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.intercepter;

import com.aizuda.snailjob.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.snailjob.common.core.model.SnailJobHeaders;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class SnailRetryHeaderAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnailRetryHeaderAspect.class);

    public void before() {
        if (this.skip()) {
            return;
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(attributes)) {
            return;
        }
        String xRetry = attributes.getRequest().getHeader("snail-job");
        if (Objects.nonNull(xRetry)) {
            RetrySiteSnapshot.setEntryMethodTime(System.currentTimeMillis());
            SnailJobLog.LOCAL.info("snail retry request header :[{}]", new Object[]{xRetry});
            RetrySiteSnapshot.setRetryHeader((SnailJobHeaders)JsonUtil.parseObject((String)xRetry, SnailJobHeaders.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@within(org.springframework.web.bind.annotation.RestController)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        this.before();
        Throwable throwable = null;
        Object result = null;
        try {
            result = point.proceed();
        }
        catch (Throwable t) {
            throwable = t;
        }
        finally {
            this.afterReturning();
        }
        if (throwable != null) {
            throw throwable;
        }
        return result;
    }

    public void afterReturning() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(attributes)) {
            return;
        }
        HttpServletResponse response = attributes.getResponse();
        if (Objects.nonNull(response)) {
            response.addHeader("snail-job-status", RetrySiteSnapshot.getRetryStatusCode());
        }
        if (this.skip()) {
            return;
        }
        if (Objects.nonNull(RetrySiteSnapshot.getStage()) && RetrySiteSnapshot.EnumStage.REMOTE.getStage() == RetrySiteSnapshot.getStage().intValue()) {
            return;
        }
        RetrySiteSnapshot.removeRetryHeader();
        RetrySiteSnapshot.removeRetryStatusCode();
        RetrySiteSnapshot.removeEntryMethodTime();
    }

    private boolean skip() {
        Integer stage = RetrySiteSnapshot.getStage();
        return Objects.nonNull(stage) && RetrySiteSnapshot.EnumStage.LOCAL.getStage() == RetrySiteSnapshot.getStage().intValue();
    }
}

