/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.strategy;

import com.aizuda.snailjob.client.common.cache.GroupVersionCache;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.core.Report;
import com.aizuda.snailjob.client.core.RetryExecutor;
import com.aizuda.snailjob.client.core.RetryExecutorParameter;
import com.aizuda.snailjob.client.core.event.SnailJobListener;
import com.aizuda.snailjob.client.core.executor.GuavaRetryExecutor;
import com.aizuda.snailjob.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.snailjob.client.core.loader.SnailRetrySpiLoader;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.client.core.retryer.RetryerResultContext;
import com.aizuda.snailjob.client.core.strategy.RetryStrategy;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.SnailJobAlarmFactory;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.model.dto.ConfigDTO;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategy;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRetryStrategies
implements RetryStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRetryStrategies.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String TEXT_MESSAGE_FORMATTER = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u91cd\u8bd5\u7ec4\u4ef6\u5f02\u5e38</font>  \n> IP:{}  \n> \u7a7a\u95f4ID:{}  \n> \u540d\u79f0:{}  \n> \u65f6\u95f4:{}  \n> \u5f02\u5e38:{}  \n";
    private final List<SnailJobListener> snailJobListeners = SnailRetrySpiLoader.loadSnailJobListener();
    @Autowired
    private List<Report> reports;
    @Autowired
    private SnailJobProperties snailJobProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetryerResultContext openRetry(String sceneName, String executorClassName, Object[] params) {
        RetryerResultContext retryerResultContext = new RetryerResultContext();
        GuavaRetryExecutor retryExecutor = new GuavaRetryExecutor(sceneName, executorClassName);
        RetryerInfo retryerInfo = retryExecutor.getRetryerInfo();
        if (!this.preValidator(retryerInfo, retryerResultContext)) {
            return retryerResultContext;
        }
        RetrySiteSnapshot.setStatus(RetrySiteSnapshot.EnumStatus.RUNNING.getStatus());
        this.setStage();
        Retryer retryer = retryExecutor.build(this.getRetryExecutorParameter(retryerInfo));
        retryerResultContext.setRetryerInfo(retryerInfo);
        try {
            for (SnailJobListener snailJobListener : this.snailJobListeners) {
                snailJobListener.beforeRetry(sceneName, executorClassName, params);
            }
            Object result = retryExecutor.call(retryer, this.doGetCallable(retryExecutor, params), this.getRetryErrorConsumer(retryerResultContext, params), this.getRetrySuccessConsumer(retryerResultContext));
            retryerResultContext.setResult(result);
        }
        catch (Exception e) {
            log.error("Unexpected exception occurred during retry, sceneName:[{}] executorClassName:[{}]", new Object[]{sceneName, executorClassName, e});
            retryerResultContext.setMessage("Unexpected exception" + e.getMessage());
            this.unexpectedError(e, retryerResultContext);
            this.sendMessage(e);
        }
        finally {
            RetrySiteSnapshot.setStatus(RetrySiteSnapshot.EnumStatus.COMPLETE.getStatus());
        }
        return retryerResultContext;
    }

    protected abstract void setStage();

    protected Consumer<Object> getRetrySuccessConsumer(RetryerResultContext retryerResultContext) {
        return o -> {
            this.success(retryerResultContext);
            Object result = retryerResultContext.getResult();
            RetryerInfo retryerInfo = retryerResultContext.getRetryerInfo();
            for (SnailJobListener snailJobListener : this.snailJobListeners) {
                snailJobListener.successOnRetry(result, retryerInfo.getScene(), retryerInfo.getExecutorClassName());
            }
            this.doRetrySuccessConsumer(retryerResultContext).accept(retryerResultContext);
        };
    }

    protected abstract Consumer<Object> doRetrySuccessConsumer(RetryerResultContext var1);

    private Consumer<Throwable> getRetryErrorConsumer(RetryerResultContext context, Object ... params) {
        return throwable -> {
            context.setThrowable((Throwable)throwable);
            context.setMessage(throwable.getMessage());
            this.error(context);
            RetryerInfo retryerInfo = context.getRetryerInfo();
            try {
                for (SnailJobListener snailJobListener : this.snailJobListeners) {
                    snailJobListener.failureOnRetry(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), (Throwable)throwable);
                }
            }
            catch (Exception e) {
                log.error(" Failure listener mode processing failed", (Throwable)e);
                throw e;
            }
            this.doGetRetryErrorConsumer(retryerInfo, params).accept((Throwable)throwable);
        };
    }

    protected abstract void error(RetryerResultContext var1);

    protected abstract boolean preValidator(RetryerInfo var1, RetryerResultContext var2);

    protected abstract void unexpectedError(Exception var1, RetryerResultContext var2);

    protected abstract void success(RetryerResultContext var1);

    protected abstract Consumer<Throwable> doGetRetryErrorConsumer(RetryerInfo var1, Object[] var2);

    protected abstract Callable doGetCallable(RetryExecutor<WaitStrategy, StopStrategy> var1, Object[] var2);

    protected abstract RetryExecutorParameter<WaitStrategy, StopStrategy> getRetryExecutorParameter(RetryerInfo var1);

    protected boolean doReport(RetryerInfo retryerInfo, Object[] params) {
        for (Report report : this.reports) {
            if (!report.supports(retryerInfo.isAsync())) continue;
            return report.report(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), params);
        }
        return Boolean.FALSE;
    }

    private void sendMessage(Exception e) {
        try {
            ConfigDTO.Notify notify = GroupVersionCache.getRetryNotifyAttribute((Integer)RetryNotifySceneEnum.CLIENT_COMPONENT_ERROR.getNotifyScene());
            if (Objects.nonNull(notify)) {
                List recipients = Optional.ofNullable(notify.getRecipients()).orElse(Lists.newArrayList());
                for (ConfigDTO.Notify.Recipient recipient : recipients) {
                    AlarmContext context = AlarmContext.build().text(TEXT_MESSAGE_FORMATTER, new Object[]{EnvironmentUtils.getActiveProfile(), NetUtil.getLocalIpStr(), this.snailJobProperties.getNamespace(), this.snailJobProperties.getGroup(), LocalDateTime.now().format(formatter), e.getMessage()}).title("retry component handling exception:[{}]", new Object[]{this.snailJobProperties.getGroup()}).notifyAttribute(recipient.getNotifyAttribute());
                    Optional.ofNullable(SnailJobAlarmFactory.getAlarmType((Integer)recipient.getNotifyType())).ifPresent(alarm -> alarm.asyncSendMessage((Object)context));
                }
            }
        }
        catch (Exception e1) {
            SnailJobLog.LOCAL.error("Client failed to send component exception alert.", new Object[]{e1});
        }
    }
}

