/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.log.dialect;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.log.dialect.Log;
import com.aizuda.snailjob.common.log.level.Level;
import java.io.Serializable;

public abstract class AbstractLog
implements Log,
Serializable {
    private static final long serialVersionUID = -3211115409504005616L;
    private static final String FQCN = AbstractLog.class.getName();

    @Override
    public boolean isEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
    }

    @Override
    public void trace(Boolean remote, Throwable t) {
        this.trace(remote, "", t);
    }

    @Override
    public void trace(Boolean remote, String msg) {
        this.trace(remote, FQCN, "", msg);
    }

    @Override
    public void trace(Boolean remote, String msg, Throwable t) {
        this.trace(remote, FQCN, msg, t);
    }

    @Override
    public void trace(Boolean remote, String format, Object ... arguments) {
        this.trace(remote, FQCN, format, arguments);
    }

    @Override
    public void debug(Boolean remote, Throwable t) {
        this.debug(remote, "", t);
    }

    @Override
    public void debug(Boolean remote, String msg, Throwable t) {
        this.debug(remote, FQCN, msg, t);
    }

    @Override
    public void debug(Boolean remote, String msg) {
        this.debug(remote, FQCN, "", msg);
    }

    @Override
    public void debug(Boolean remote, String format, Object ... arguments) {
        this.debug(remote, FQCN, format, arguments);
    }

    @Override
    public void info(Boolean remote, Throwable t) {
        this.info(remote, FQCN, "", t);
    }

    @Override
    public void info(Boolean remote, String msg, Throwable t) {
        this.info(remote, FQCN, msg, t);
    }

    @Override
    public void info(Boolean remote, String msg) {
        this.info(remote, FQCN, msg, new Object[0]);
    }

    @Override
    public void info(Boolean remote, String format, Object ... arguments) {
        this.info(remote, FQCN, format, arguments);
    }

    @Override
    public void warn(Boolean remote, String format, Object ... arguments) {
        this.warn(remote, FQCN, format, arguments);
    }

    @Override
    public void error(Boolean remote, String msg, Throwable t) {
        this.error(remote, FQCN, msg, t);
    }

    @Override
    public void error(Boolean remote, String msg) {
        this.error(remote, FQCN, msg, new Object[0]);
    }

    @Override
    public void error(Boolean remote, Throwable t) {
        this.error(remote, FQCN, "", t);
    }

    @Override
    public void error(Boolean remote, String format, Object ... arguments) {
        this.error(remote, FQCN, format, arguments);
    }

    @Override
    public void warn(Boolean remote, String msg, Throwable t) {
        this.warn(remote, FQCN, msg, t);
    }

    @Override
    public void warn(Boolean remote, String msg) {
        this.warn(remote, FQCN, msg, new Object[0]);
    }

    @Override
    public void warn(Boolean remote, Throwable t) {
        this.warn(remote, FQCN, "", t);
    }

    @Override
    public void log(Level level, Boolean remote, String format, Object ... arguments) {
        this.log(level, remote, FQCN, format, arguments);
    }
}

