/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.log.dto;

import com.aizuda.snailjob.common.log.dto.TaskLogFieldDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class LogContentDTO {
    private List<TaskLogFieldDTO> fieldList = new ArrayList<TaskLogFieldDTO>();

    public List<TaskLogFieldDTO> getFieldList() {
        return this.fieldList;
    }

    public Map<String, String> toMap() {
        return this.fieldList.stream().filter(logTaskDTO_ -> !Objects.isNull(logTaskDTO_.getValue())).collect(Collectors.toMap(TaskLogFieldDTO::getName, TaskLogFieldDTO::getValue));
    }

    public void addField(String name, String value) {
        this.fieldList.add(new TaskLogFieldDTO(name, value));
    }

    public void addTimeStamp(Long timeStamp) {
        this.addField("time_stamp", String.valueOf(timeStamp));
    }

    public Long getTimeStamp() {
        return Long.parseLong(this.fieldList.stream().filter(taskLogFieldDTO -> !Objects.isNull(taskLogFieldDTO.getValue())).collect(Collectors.toMap(TaskLogFieldDTO::getName, TaskLogFieldDTO::getValue)).get("time_stamp"));
    }

    public void addLevelField(String level) {
        this.addField("level", level);
    }

    public void addThreadField(String thread) {
        this.addField("thread", thread);
    }

    public void addMessageField(String message) {
        this.addField("message", message);
    }

    public void addLocationField(String location) {
        this.addField("location", location);
    }

    public void addThrowableField(String throwable) {
        this.addField("throwable", throwable);
    }

    public void addHostField(String host) {
        this.addField("host", host);
    }

    public void addPortField(Integer port) {
        this.addField("port", String.valueOf(port));
    }
}

