/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.timer;

import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.common.enums.WebSocketSceneEnum;
import com.aizuda.snailjob.server.common.vo.JobLogQueryVO;
import com.aizuda.snailjob.server.web.service.JobLogService;
import com.aizuda.snailjob.server.web.timer.LogTimerWheel;
import io.netty.util.Timeout;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import lombok.Generated;

public class JobTaskLogTimerTask
implements TimerTask<String> {
    private static final String IDEMPOTENT_KEY_PREFIX = "jobTaskLog_{0}_{1}_{2}";
    private JobLogQueryVO logQueryVO;
    private String sid;

    public void run(Timeout timeout) throws Exception {
        SnailJobLog.LOCAL.debug("Start querying scheduled task logs. Current time:[{}] jobTaskId:[{}]", new Object[]{LocalDateTime.now(), this.logQueryVO.getTaskBatchId()});
        try {
            LogTimerWheel.clearCache(this.idempotentKey());
            JobLogService logService = (JobLogService)SnailSpringContext.getBean(JobLogService.class);
            logService.getJobLogPage(this.logQueryVO);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Scheduled task log query execution failed", new Object[]{e});
        }
    }

    public String idempotentKey() {
        Long jobTaskId = this.logQueryVO.getTaskBatchId();
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.sid, WebSocketSceneEnum.JOB_LOG_SCENE, jobTaskId);
    }

    @Generated
    public JobTaskLogTimerTask(JobLogQueryVO logQueryVO, String sid) {
        this.logQueryVO = logQueryVO;
        this.sid = sid;
    }
}

