/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.TimeZone;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public abstract class AbstractCsvOutputFormat<T>
extends FileOutputFormat<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCsvOutputFormat.class);
    public static final String DEFAULT_LINE_DELIMITER = "\n";
    public static final String DEFAULT_FIELD_DELIMITER = String.valueOf(",");
    private transient Writer wrt;
    private String recordDelimiter;
    private String fieldDelimiter;
    private String quoteCharacter;
    private String doubleQuotes;
    private String charsetName;
    private boolean allowNullValues;
    private boolean quoteStrings = false;
    private TimeZone timezone = TimeZone.getTimeZone("UTC");
    private boolean outputFieldName = false;
    private String[] fieldNames = null;

    public AbstractCsvOutputFormat(Path outputPath) {
        this(outputPath, DEFAULT_LINE_DELIMITER, DEFAULT_FIELD_DELIMITER);
    }

    public AbstractCsvOutputFormat(Path outputPath, String fieldDelimiter) {
        this(outputPath, DEFAULT_LINE_DELIMITER, fieldDelimiter);
    }

    public AbstractCsvOutputFormat(Path outputPath, String recordDelimiter, String fieldDelimiter) {
        this(outputPath, recordDelimiter, fieldDelimiter, null);
    }

    public AbstractCsvOutputFormat(Path outputPath, String recordDelimiter, String fieldDelimiter, String quoteCharacter) {
        super(outputPath);
        this.setRecordDelimiter(recordDelimiter);
        this.setFieldDelimiter(fieldDelimiter);
        this.setQuoteCharacter(quoteCharacter);
        this.allowNullValues = false;
    }

    public AbstractCsvOutputFormat(Path outputPath, String recordDelimiter, String fieldDelimiter, char quoteCharacter) {
        super(outputPath);
        this.setRecordDelimiter(recordDelimiter);
        this.setFieldDelimiter(fieldDelimiter);
        this.setQuoteCharacter(quoteCharacter);
        this.allowNullValues = false;
    }

    public void setRecordDelimiter(String recordDelimiter) {
        Preconditions.checkArgument((recordDelimiter != null ? 1 : 0) != 0, (Object)"RecordDelmiter shall not be null.");
        this.recordDelimiter = recordDelimiter;
    }

    public void setFieldDelimiter(String fieldDelimiter) {
        Preconditions.checkArgument((fieldDelimiter != null ? 1 : 0) != 0, (Object)"FieldDelimiter shall not be null.");
        this.fieldDelimiter = fieldDelimiter;
    }

    public void setQuoteCharacter(String character) {
        Preconditions.checkArgument((character == null || character.length() == 1 ? 1 : 0) != 0, (Object)"character should be a single character string");
        if (character == null) {
            this.quoteCharacter = null;
            this.doubleQuotes = null;
        } else {
            this.quoteCharacter = character;
            this.doubleQuotes = this.quoteCharacter + this.quoteCharacter;
        }
    }

    public void setQuoteCharacter(char character) {
        this.quoteCharacter = Character.toString(character);
        this.doubleQuotes = this.quoteCharacter + this.quoteCharacter;
    }

    public void setAllowNullValues(boolean allowNulls) {
        this.allowNullValues = allowNulls;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void setQuoteStrings(boolean quoteStrings) {
        this.quoteStrings = quoteStrings;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public void setOutputFieldName(boolean outputFieldName) {
        this.outputFieldName = outputFieldName;
    }

    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        this.wrt = this.charsetName == null ? new OutputStreamWriter(new BufferedOutputStream((OutputStream)this.stream, 4096)) : new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)this.stream, 4096), this.charsetName);
    }

    public void close() throws IOException {
        if (this.wrt != null) {
            this.wrt.flush();
            this.wrt.close();
            this.wrt = null;
        }
        super.close();
    }

    protected abstract Object getSpecificField(T var1, int var2);

    protected abstract int getFieldsNum(T var1);

    public void writeRecord(T record) throws IOException {
        if (this.outputFieldName) {
            this.outputFieldNames();
        }
        this.outputRecord(record);
    }

    private void outputFieldNames() throws IOException {
        this.outputFieldName = false;
        if (null == this.fieldNames || this.fieldNames.length == 0) {
            throw new RuntimeException("Field names are empty");
        }
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (i != 0) {
                this.wrt.write(this.fieldDelimiter);
            }
            this.wrt.write(this.getEscapedString(this.fieldNames[i]));
        }
        this.wrt.write(this.recordDelimiter);
    }

    private void outputRecord(T record) throws IOException {
        int numFields = this.getFieldsNum(record);
        for (int i = 0; i < numFields; ++i) {
            Object v = this.getSpecificField(record, i);
            if (v != null) {
                if (i != 0) {
                    this.wrt.write(this.fieldDelimiter);
                }
                if (this.quoteStrings && this.quoteCharacter != null && (v instanceof String || v instanceof StringValue)) {
                    String value = v.toString();
                    this.wrt.write(this.getQuotedEscapedString(value));
                    continue;
                }
                if (v instanceof Date) {
                    String date = TimeConvertUtils.unixDateToString((int)TimeConvertUtils.toInt((java.util.Date)((Date)v)));
                    this.wrt.write(date);
                    continue;
                }
                if (v instanceof Time) {
                    String time = TimeConvertUtils.unixTimeToString((int)TimeConvertUtils.toInt((Time)((Time)v)));
                    this.wrt.write(time);
                    continue;
                }
                if (v instanceof Timestamp) {
                    long val = ((Timestamp)v).getTime();
                    long offset = this.timezone.getOffset(val);
                    String timestamp = TimeConvertUtils.unixTimestampToString((long)(val + offset), (int)3);
                    this.wrt.write(timestamp);
                    continue;
                }
                if (v instanceof BigDecimal) {
                    String value = ((BigDecimal)v).toPlainString();
                    this.wrt.write(value);
                    continue;
                }
                if (v instanceof byte[]) {
                    String value = Arrays.toString((byte[])v);
                    this.wrt.write(this.getEscapedString(value));
                    continue;
                }
                String value = v.toString();
                this.wrt.write(this.getEscapedString(value));
                continue;
            }
            if (this.allowNullValues) {
                if (i == 0) continue;
                this.wrt.write(this.fieldDelimiter);
                continue;
            }
            throw new RuntimeException("Cannot write tuple with <null> value at position: " + i);
        }
        this.wrt.write(this.recordDelimiter);
    }

    private String getEscapedString(String value) {
        boolean hasDelim;
        if (this.quoteCharacter == null) {
            return value;
        }
        boolean quote = value.contains(this.quoteCharacter);
        boolean bl = hasDelim = value.contains(this.fieldDelimiter) || value.contains(this.recordDelimiter);
        if (quote || hasDelim) {
            return this.getQuotedEscapedString(value);
        }
        return value;
    }

    private String getQuotedEscapedString(String value) {
        Preconditions.checkArgument((this.quoteCharacter != null ? 1 : 0) != 0, (Object)"Quote character can't be null");
        value = value.replaceAll(this.quoteCharacter, this.doubleQuotes);
        return this.quoteCharacter + value + this.quoteCharacter;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " (path: " + this.getOutputFilePath() + ", delimiter: " + this.fieldDelimiter + ")";
    }
}

