/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.AbstractCsvOutputFormat;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.core.fs.Path;

@PublicEvolving
public class CsvOutputFormat<T extends Tuple>
extends AbstractCsvOutputFormat<T>
implements InputTypeConfigurable {
    public static final String DEFAULT_LINE_DELIMITER = "\n";
    public static final String DEFAULT_FIELD_DELIMITER = AbstractCsvOutputFormat.DEFAULT_FIELD_DELIMITER;

    public CsvOutputFormat(Path outputPath) {
        super(outputPath);
    }

    public CsvOutputFormat(Path outputPath, String fieldDelimiter) {
        super(outputPath, fieldDelimiter);
    }

    public CsvOutputFormat(Path outputPath, String recordDelimiter, String fieldDelimiter) {
        super(outputPath, recordDelimiter, fieldDelimiter);
    }

    @Override
    protected Object getSpecificField(T record, int n) {
        return record.getField(n);
    }

    @Override
    protected int getFieldsNum(T record) {
        return record.getArity();
    }

    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        if (!type.isTupleType()) {
            throw new InvalidProgramException("The " + CsvOutputFormat.class.getSimpleName() + " can only be used to write tuple data sets.");
        }
    }
}

