/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.util.InstantiationUtil;

@PublicEvolving
public class PrimitiveInputFormat<OT>
extends DelimitedInputFormat<OT> {
    private static final long serialVersionUID = 1L;
    private Class<OT> primitiveClass;
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte NEW_LINE = 10;
    private transient FieldParser<OT> parser;

    public PrimitiveInputFormat(Path filePath, Class<OT> primitiveClass) {
        super(filePath, null);
        this.primitiveClass = primitiveClass;
    }

    public PrimitiveInputFormat(Path filePath, String delimiter, Class<OT> primitiveClass) {
        super(filePath, null);
        this.primitiveClass = primitiveClass;
        this.setDelimiter(delimiter);
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        Class parserType = FieldParser.getParserForType(this.primitiveClass);
        if (parserType == null) {
            throw new IllegalArgumentException("The type '" + this.primitiveClass.getName() + "' is not supported for the primitive input format.");
        }
        this.parser = (FieldParser)InstantiationUtil.instantiate((Class)parserType, FieldParser.class);
    }

    public OT readRecord(OT reuse, byte[] bytes, int offset, int numBytes) throws IOException {
        if (this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10 && offset + numBytes >= 1 && bytes[offset + numBytes - 1] == 13) {
            --numBytes;
        }
        if (this.parser.resetErrorStateAndParse(bytes, offset, numBytes + offset, new byte[]{0}, reuse, false) >= 0) {
            return (OT)this.parser.getLastResult();
        }
        String s = new String(bytes, offset, numBytes, this.getCharset());
        throw new IOException("Could not parse value: \"" + s + "\" as type " + this.primitiveClass.getSimpleName());
    }
}

