/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.consuming;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.rocketmq.common.message.MessageQueue;

public class RocketMQMessageQueueChooser {
    private volatile int queueIndex = 0;
    private volatile List<MessageQueue> messageQueues;

    public MessageQueue choose() {
        return this.messageQueues.get(this.queueIndex);
    }

    public int requeue() {
        this.queueIndex = this.queueIndex - 1 < 0 ? this.messageQueues.size() - 1 : --this.queueIndex;
        return this.queueIndex;
    }

    public void increment() {
        this.queueIndex = (this.queueIndex + 1) % this.messageQueues.size();
    }

    public void reset(Set<MessageQueue> queueSet) {
        this.messageQueues = null;
        this.messageQueues = new ArrayList<MessageQueue>(queueSet);
        this.queueIndex = 0;
    }

    public List<MessageQueue> getMessageQueues() {
        return this.messageQueues;
    }
}

