/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.expire;

import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.CurrentConcurrencyManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.TokenCacheNode;
import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.expire.ExpireStrategy;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionManager;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class RegularExpireStrategy
implements ExpireStrategy {
    private long executeCount = 1000L;
    private long executeDuration = 800L;
    private long executeRate = 1000L;
    private ConcurrentLinkedHashMap<Long, TokenCacheNode> localCache;
    private static ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("regular clear expired token thread", true));

    public RegularExpireStrategy(ConcurrentLinkedHashMap<Long, TokenCacheNode> localCache) {
        AssertUtil.isTrue((localCache != null ? 1 : 0) != 0, (String)" local cache can't be null");
        this.localCache = localCache;
    }

    @Override
    public void startClearTaskRegularly() {
        executor.scheduleAtFixedRate(new ClearExpiredTokenTask(), 0L, this.executeRate, TimeUnit.MILLISECONDS);
    }

    private void clearToken() {
        long start = System.currentTimeMillis();
        ArrayList keyList = new ArrayList(this.localCache.keySet());
        for (int i = 0; (long)i < this.executeCount && i < keyList.size(); ++i) {
            if (System.currentTimeMillis() - start > this.executeDuration) {
                RecordLog.info((String)"[RegularExpireStrategy] End the process of expired token detection because of execute time is more than executeDuration: {}", (Object[])new Object[]{this.executeDuration});
                break;
            }
            Long key = (Long)keyList.get(i);
            TokenCacheNode node = (TokenCacheNode)this.localCache.get((Object)key);
            if (node == null) continue;
            if (!ConnectionManager.isClientOnline(node.getClientAddress()) && node.getClientTimeout() - System.currentTimeMillis() < 0L) {
                this.removeToken(key, node);
                RecordLog.info((String)"[RegularExpireStrategy] Delete the expired token<{}> because of client offline for ruleId<{}>", (Object[])new Object[]{node.getTokenId(), node.getFlowId()});
                continue;
            }
            long resourceTimeout = ClusterFlowRuleManager.getFlowRuleById(node.getFlowId()).getClusterConfig().getResourceTimeout();
            if (System.currentTimeMillis() - node.getResourceTimeout() <= resourceTimeout) continue;
            this.removeToken(key, node);
            RecordLog.info((String)"[RegularExpireStrategy] Delete the expired token<{}> because of resource timeout for ruleId<{}>", (Object[])new Object[]{node.getTokenId(), node.getFlowId()});
        }
    }

    private void removeToken(long tokenId, TokenCacheNode node) {
        if (this.localCache.remove((Object)tokenId) == null) {
            RecordLog.info((String)"[RegularExpireStrategy] Token<{}> is already released for ruleId<{}>", (Object[])new Object[]{tokenId, node.getFlowId()});
            return;
        }
        AtomicInteger nowCalls = CurrentConcurrencyManager.get(node.getFlowId());
        if (nowCalls == null) {
            return;
        }
        nowCalls.getAndAdd(node.getAcquireCount() * -1);
    }

    private class ClearExpiredTokenTask
    implements Runnable {
        private ClearExpiredTokenTask() {
        }

        @Override
        public void run() {
            try {
                RegularExpireStrategy.this.clearToken();
            }
            catch (Throwable e) {
                e.printStackTrace();
                RecordLog.warn((String)"[RegularExpireStrategy] undefined throwable during clear token: ", (Throwable)e);
            }
        }
    }
}

