/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.processor;

import com.alibaba.csp.sentinel.cluster.annotation.RequestType;
import com.alibaba.csp.sentinel.cluster.server.processor.RequestProcessor;
import com.alibaba.csp.sentinel.spi.SpiLoader;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RequestProcessorProvider {
    private static final Map<Integer, RequestProcessor> PROCESSOR_MAP = new ConcurrentHashMap<Integer, RequestProcessor>();

    private static void loadAndInit() {
        List processors = SpiLoader.of(RequestProcessor.class).loadInstanceList();
        for (RequestProcessor processor : processors) {
            Integer type = RequestProcessorProvider.parseRequestType(processor);
            if (type == null) continue;
            PROCESSOR_MAP.put(type, processor);
        }
    }

    private static Integer parseRequestType(RequestProcessor processor) {
        RequestType requestType = processor.getClass().getAnnotation(RequestType.class);
        if (requestType != null) {
            return requestType.value();
        }
        return null;
    }

    public static RequestProcessor getProcessor(int type) {
        return PROCESSOR_MAP.get(type);
    }

    static void addProcessorIfAbsent(int type, RequestProcessor processor) {
        PROCESSOR_MAP.putIfAbsent(type, processor);
    }

    static void addProcessor(int type, RequestProcessor processor) {
        AssertUtil.notNull((Object)processor, (String)"processor cannot be null");
        PROCESSOR_MAP.put(type, processor);
    }

    private RequestProcessorProvider() {
    }

    static {
        RequestProcessorProvider.loadAndInit();
    }
}

