/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.zuul.api.route;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import com.netflix.zuul.context.RequestContext;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class PrefixRoutePathMatcher
implements Predicate<RequestContext> {
    private final String pattern;
    private final PathMatcher pathMatcher;
    private final boolean canMatch;

    public PrefixRoutePathMatcher(String pattern) {
        AssertUtil.assertNotBlank((String)pattern, (String)"pattern cannot be blank");
        this.pattern = pattern;
        this.pathMatcher = new AntPathMatcher();
        this.canMatch = this.pathMatcher.isPattern(pattern);
    }

    public boolean test(RequestContext context) {
        String path = context.getRequest().getServletPath();
        if (this.canMatch) {
            return this.pathMatcher.match(this.pattern, path);
        }
        return false;
    }

    public String getPattern() {
        return this.pattern;
    }
}

