/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.nlp.understanding;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.Map;

public class UnderstandingParam
extends HalfDuplexServiceParam {
    private String sentence;
    private String labels;
    private String task;

    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("sentence", this.sentence);
        jsonObject.addProperty("labels", this.labels);
        if (this.task != null && !this.task.isEmpty()) {
            jsonObject.addProperty("task", this.task);
        }
        return jsonObject;
    }

    @Override
    public ByteBuffer getBinaryData() {
        return null;
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("model", this.getModel());
        requestObject.add("input", (JsonElement)this.getInput());
        Map<String, Object> params = this.getParameters();
        if (params != null && !params.isEmpty()) {
            requestObject.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(params));
        } else {
            requestObject.add("parameters", (JsonElement)new JsonObject());
        }
        return requestObject;
    }

    @Override
    public void validate() throws InputRequiredException {
    }

    protected UnderstandingParam(UnderstandingParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.sentence = ((UnderstandingParamBuilder)b).sentence;
        this.labels = ((UnderstandingParamBuilder)b).labels;
        this.task = ((UnderstandingParamBuilder)b).task;
    }

    public static UnderstandingParamBuilder<?, ?> builder() {
        return new UnderstandingParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnderstandingParam)) {
            return false;
        }
        UnderstandingParam other = (UnderstandingParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$sentence = this.getSentence();
        String other$sentence = other.getSentence();
        if (this$sentence == null ? other$sentence != null : !this$sentence.equals(other$sentence)) {
            return false;
        }
        String this$labels = this.getLabels();
        String other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !this$labels.equals(other$labels)) {
            return false;
        }
        String this$task = this.getTask();
        String other$task = other.getTask();
        return !(this$task == null ? other$task != null : !this$task.equals(other$task));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnderstandingParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $sentence = this.getSentence();
        result = result * 59 + ($sentence == null ? 43 : $sentence.hashCode());
        String $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : $labels.hashCode());
        String $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        return result;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getTask() {
        return this.task;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public void setTask(String task) {
        this.task = task;
    }

    @Override
    public String toString() {
        return "UnderstandingParam(sentence=" + this.getSentence() + ", labels=" + this.getLabels() + ", task=" + this.getTask() + ")";
    }

    private static final class UnderstandingParamBuilderImpl
    extends UnderstandingParamBuilder<UnderstandingParam, UnderstandingParamBuilderImpl> {
        private UnderstandingParamBuilderImpl() {
        }

        @Override
        protected UnderstandingParamBuilderImpl self() {
            return this;
        }

        @Override
        public UnderstandingParam build() {
            return new UnderstandingParam(this);
        }
    }

    public static abstract class UnderstandingParamBuilder<C extends UnderstandingParam, B extends UnderstandingParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private String sentence;
        private String labels;
        private String task;

        public B sentence(String sentence) {
            this.sentence = sentence;
            return (B)this.self();
        }

        public B labels(String labels) {
            this.labels = labels;
            return (B)this.self();
        }

        public B task(String task) {
            this.task = task;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "UnderstandingParam.UnderstandingParamBuilder(super=" + super.toString() + ", sentence=" + this.sentence + ", labels=" + this.labels + ", task=" + this.task + ")";
        }
    }
}

