/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.DashScopeHeaders;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.HttpRequest;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.ServiceOption;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.protocol.WebSocketEventType;
import com.alibaba.dashscope.utils.Constants;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HalfDuplexRequest {
    private static final Logger log = LoggerFactory.getLogger(HalfDuplexRequest.class);
    HalfDuplexParamBase param;
    ServiceOption serviceOption;

    public HalfDuplexRequest(HalfDuplexParamBase param, ServiceOption option) {
        this.param = param;
        this.serviceOption = option;
    }

    public boolean getIsFlatten() {
        return this.serviceOption.getIsFlatten();
    }

    public String getApiKey() {
        return this.param.getApiKey();
    }

    public StreamingMode getStreamingMode() {
        return this.serviceOption.getStreamingMode();
    }

    public OutputMode getOutputMode() {
        return this.serviceOption.getOutputMode();
    }

    public String getBaseWebSocketUrl() {
        return this.serviceOption.getBaseWebSocketUrl();
    }

    public String getHttpUrl() {
        String baseUrl = Constants.baseHttpApiUrl;
        if (this.serviceOption.getBaseHttpUrl() != null) {
            baseUrl = this.serviceOption.getBaseHttpUrl();
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl + this.serviceOption.httpUrl();
    }

    public boolean isSecurityCheck() {
        return this.param.isSecurityCheck();
    }

    public HttpMethod getHttpMethod() {
        return this.serviceOption.getHttpMethod();
    }

    public HttpRequest getHttpRequest() throws NoApiKeyException, ApiException {
        if (this.getHttpMethod() == HttpMethod.GET) {
            return ((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)HttpRequest.builder().url(this.getHttpUrl())).httpMethod(this.getHttpMethod())).headers(DashScopeHeaders.buildHttpHeaders(this.param.getApiKey(), this.param.isSecurityCheck(), Protocol.HTTP, this.serviceOption.getIsSSE(), this.serviceOption.getIsAsyncTask(), this.param.getWorkspace(), this.param.getHeaders()))).parameters(this.param.getParameters())).httpMethod(this.getHttpMethod())).build();
        }
        if (this.getHttpMethod() == HttpMethod.POST || this.getHttpMethod() == HttpMethod.DELETE) {
            JsonObject body = this.param.getHttpBody();
            return ((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)HttpRequest.builder().url(this.getHttpUrl())).headers(DashScopeHeaders.buildHttpHeaders(this.param.getApiKey(), this.param.isSecurityCheck(), Protocol.HTTP, this.serviceOption.getIsSSE(), this.serviceOption.getIsAsyncTask(), this.param.getWorkspace(), this.param.getHeaders()))).body(body == null ? null : JsonUtils.toJson(body))).httpMethod(this.getHttpMethod())).build();
        }
        return ((HttpRequest.HttpRequestBuilder)HttpRequest.builder().httpMethod(this.getHttpMethod())).build();
    }

    public JsonObject getWebSocketPayload() {
        JsonObject request = new JsonObject();
        request.addProperty("model", this.param.getModel());
        request.addProperty("task_group", this.serviceOption.getTaskGroup());
        request.addProperty("task", this.serviceOption.getTask());
        request.addProperty("function", this.serviceOption.getFunction());
        if (this.param.getBinaryData() == null) {
            request.add("input", (JsonElement)((JsonObject)this.param.getInput()));
        }
        if (this.param.getParameters() != null) {
            request.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.param.getParameters()));
        }
        if (this.param.getResources() != null) {
            request.add("resources", (JsonElement)this.param.getResources());
        }
        return request;
    }

    public JsonObject getWebSocketPayload(Object data) {
        JsonObject request = new JsonObject();
        request.addProperty("model", this.param.getModel());
        request.addProperty("task_group", this.serviceOption.getTaskGroup());
        request.addProperty("task", this.serviceOption.getTask());
        request.addProperty("function", this.serviceOption.getFunction());
        if (data instanceof String) {
            request.add("input", (JsonElement)((JsonObject)this.param.getInput()));
        } else {
            request.add("input", (JsonElement)new JsonObject());
        }
        if (this.param.getParameters() != null) {
            request.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.param.getParameters()));
        }
        if (this.param.getResources() != null) {
            request.add("resources", (JsonElement)((JsonObject)this.param.getResources()));
        }
        return request;
    }

    public JsonObject getStartTaskMessage() {
        JsonObject header = new JsonObject();
        header.addProperty("action", WebSocketEventType.RUN_TASK.getValue());
        header.addProperty("task_id", UUID.randomUUID().toString());
        header.addProperty("streaming", this.serviceOption.getStreamingMode().getValue());
        JsonObject wsMessage = new JsonObject();
        wsMessage.add("header", (JsonElement)header);
        wsMessage.add("payload", (JsonElement)this.getWebSocketPayload());
        return wsMessage;
    }

    public ByteBuffer getWebsocketBinaryData() {
        return this.param.getBinaryData();
    }

    public Map<String, String> getHeaders() {
        return this.param.getHeaders();
    }

    public String getWorkspace() {
        return this.param.getWorkspace();
    }
}

