/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.threads.runs;

import com.alibaba.dashscope.base.FlattenHalfDuplexParamBase;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.threads.messages.MessageParamBase;
import com.alibaba.dashscope.tools.ToolBase;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class RunParam
extends FlattenHalfDuplexParamBase {
    @SerializedName(value="assistant_id")
    @NonNull
    protected String assistantId;
    protected String model;
    protected String instructions;
    @SerializedName(value="additional_instructions")
    protected String additionalInstructions;
    @SerializedName(value="additional_messages")
    protected List<MessageParamBase> additionalMessages;
    protected List<ToolBase> tools;
    @SerializedName(value="metadata")
    protected Map<String, String> metadata;
    protected Float temperature;
    protected Boolean stream;
    @SerializedName(value="max_prompt_tokens")
    protected Integer maxPromptTokens;
    @SerializedName(value="max_completion_tokens")
    protected Integer maxCompletionTokens;
    @SerializedName(value="truncation_strategy")
    protected TruncationStrategy truncationStrategy;
    @SerializedName(value="tool_choice")
    protected Object toolChoice;
    @SerializedName(value="response_format")
    protected Object responseFormat;

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("assistant_id", this.assistantId);
        requestObject.addProperty("stream", this.stream);
        if (this.model != null && !this.model.isEmpty()) {
            requestObject.addProperty("model", this.model);
        }
        if (this.instructions != null && !this.instructions.isEmpty()) {
            requestObject.addProperty("instructions", this.instructions);
        }
        if (this.additionalInstructions != null && !this.additionalInstructions.isEmpty()) {
            requestObject.addProperty("additional_instructions", this.additionalInstructions);
        }
        if (this.additionalMessages != null && !this.additionalMessages.isEmpty()) {
            requestObject.add("additional_messages", (JsonElement)JsonUtils.toJsonArray(this.additionalMessages));
        }
        if (this.tools != null && !this.tools.isEmpty()) {
            requestObject.add("tools", (JsonElement)JsonUtils.toJsonArray(this.tools));
        }
        if (this.metadata != null && !this.metadata.isEmpty()) {
            requestObject.add("metadata", (JsonElement)JsonUtils.toJsonObject(this.metadata));
        }
        if (this.temperature != null) {
            requestObject.addProperty("temperature", (Number)this.temperature);
        }
        if (this.maxPromptTokens != null) {
            requestObject.addProperty("max_prompt_tokens", (Number)this.maxPromptTokens);
        }
        if (this.maxCompletionTokens != null) {
            requestObject.addProperty("max_completion_tokens", (Number)this.maxCompletionTokens);
        }
        if (this.truncationStrategy != null) {
            requestObject.add("truncation_strategy", (JsonElement)JsonUtils.toJsonObject(this.truncationStrategy));
        }
        if (this.toolChoice != null) {
            if (this.toolChoice instanceof String) {
                requestObject.addProperty("tool_choice", (String)this.toolChoice);
            } else {
                requestObject.add("tool_choice", (JsonElement)JsonUtils.toJsonObject(this.toolChoice));
            }
        }
        if (this.responseFormat != null) {
            requestObject.addProperty("response_format", (String)this.responseFormat);
        }
        this.addExtraBody(requestObject);
        return requestObject;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.assistantId == null || this.assistantId.isEmpty()) {
            throw new InputRequiredException("The assistantId must be set");
        }
        if (this.responseFormat != null && this.responseFormat instanceof String && ((String)this.responseFormat).equals("json_object")) {
            return;
        }
        throw new InputRequiredException("The response format only support json_object");
    }

    private static Map<String, String> $default$metadata() {
        return null;
    }

    private static Boolean $default$stream() {
        return false;
    }

    private static Object $default$responseFormat() {
        return "json_object";
    }

    protected RunParam(RunParamBuilder<?, ?> b) {
        super((FlattenHalfDuplexParamBase.FlattenHalfDuplexParamBaseBuilder<?, ?>)b);
        List<Object> tools;
        List<Object> additionalMessages;
        this.assistantId = ((RunParamBuilder)b).assistantId;
        if (this.assistantId == null) {
            throw new NullPointerException("assistantId is marked non-null but is null");
        }
        this.model = ((RunParamBuilder)b).model;
        this.instructions = ((RunParamBuilder)b).instructions;
        this.additionalInstructions = ((RunParamBuilder)b).additionalInstructions;
        switch (((RunParamBuilder)b).additionalMessages == null ? 0 : ((RunParamBuilder)b).additionalMessages.size()) {
            case 0: {
                additionalMessages = Collections.emptyList();
                break;
            }
            case 1: {
                additionalMessages = Collections.singletonList(((RunParamBuilder)b).additionalMessages.get(0));
                break;
            }
            default: {
                additionalMessages = Collections.unmodifiableList(new ArrayList(((RunParamBuilder)b).additionalMessages));
            }
        }
        this.additionalMessages = additionalMessages;
        switch (((RunParamBuilder)b).tools == null ? 0 : ((RunParamBuilder)b).tools.size()) {
            case 0: {
                tools = Collections.emptyList();
                break;
            }
            case 1: {
                tools = Collections.singletonList(((RunParamBuilder)b).tools.get(0));
                break;
            }
            default: {
                tools = Collections.unmodifiableList(new ArrayList(((RunParamBuilder)b).tools));
            }
        }
        this.tools = tools;
        this.metadata = ((RunParamBuilder)b).metadata$set ? ((RunParamBuilder)b).metadata$value : RunParam.$default$metadata();
        this.temperature = ((RunParamBuilder)b).temperature;
        this.stream = ((RunParamBuilder)b).stream$set ? ((RunParamBuilder)b).stream$value : RunParam.$default$stream();
        this.maxPromptTokens = ((RunParamBuilder)b).maxPromptTokens;
        this.maxCompletionTokens = ((RunParamBuilder)b).maxCompletionTokens;
        this.truncationStrategy = ((RunParamBuilder)b).truncationStrategy;
        this.toolChoice = ((RunParamBuilder)b).toolChoice;
        this.responseFormat = ((RunParamBuilder)b).responseFormat$set ? ((RunParamBuilder)b).responseFormat$value : RunParam.$default$responseFormat();
    }

    public static RunParamBuilder<?, ?> builder() {
        return new RunParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunParam)) {
            return false;
        }
        RunParam other = (RunParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Integer this$maxPromptTokens = this.getMaxPromptTokens();
        Integer other$maxPromptTokens = other.getMaxPromptTokens();
        if (this$maxPromptTokens == null ? other$maxPromptTokens != null : !((Object)this$maxPromptTokens).equals(other$maxPromptTokens)) {
            return false;
        }
        Integer this$maxCompletionTokens = this.getMaxCompletionTokens();
        Integer other$maxCompletionTokens = other.getMaxCompletionTokens();
        if (this$maxCompletionTokens == null ? other$maxCompletionTokens != null : !((Object)this$maxCompletionTokens).equals(other$maxCompletionTokens)) {
            return false;
        }
        String this$assistantId = this.getAssistantId();
        String other$assistantId = other.getAssistantId();
        if (this$assistantId == null ? other$assistantId != null : !this$assistantId.equals(other$assistantId)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$instructions = this.getInstructions();
        String other$instructions = other.getInstructions();
        if (this$instructions == null ? other$instructions != null : !this$instructions.equals(other$instructions)) {
            return false;
        }
        String this$additionalInstructions = this.getAdditionalInstructions();
        String other$additionalInstructions = other.getAdditionalInstructions();
        if (this$additionalInstructions == null ? other$additionalInstructions != null : !this$additionalInstructions.equals(other$additionalInstructions)) {
            return false;
        }
        List<MessageParamBase> this$additionalMessages = this.getAdditionalMessages();
        List<MessageParamBase> other$additionalMessages = other.getAdditionalMessages();
        if (this$additionalMessages == null ? other$additionalMessages != null : !((Object)this$additionalMessages).equals(other$additionalMessages)) {
            return false;
        }
        List<ToolBase> this$tools = this.getTools();
        List<ToolBase> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        TruncationStrategy this$truncationStrategy = this.getTruncationStrategy();
        TruncationStrategy other$truncationStrategy = other.getTruncationStrategy();
        if (this$truncationStrategy == null ? other$truncationStrategy != null : !((Object)this$truncationStrategy).equals(other$truncationStrategy)) {
            return false;
        }
        Object this$toolChoice = this.getToolChoice();
        Object other$toolChoice = other.getToolChoice();
        if (this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice)) {
            return false;
        }
        Object this$responseFormat = this.getResponseFormat();
        Object other$responseFormat = other.getResponseFormat();
        return !(this$responseFormat == null ? other$responseFormat != null : !this$responseFormat.equals(other$responseFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RunParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Integer $maxPromptTokens = this.getMaxPromptTokens();
        result = result * 59 + ($maxPromptTokens == null ? 43 : ((Object)$maxPromptTokens).hashCode());
        Integer $maxCompletionTokens = this.getMaxCompletionTokens();
        result = result * 59 + ($maxCompletionTokens == null ? 43 : ((Object)$maxCompletionTokens).hashCode());
        String $assistantId = this.getAssistantId();
        result = result * 59 + ($assistantId == null ? 43 : $assistantId.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $instructions = this.getInstructions();
        result = result * 59 + ($instructions == null ? 43 : $instructions.hashCode());
        String $additionalInstructions = this.getAdditionalInstructions();
        result = result * 59 + ($additionalInstructions == null ? 43 : $additionalInstructions.hashCode());
        List<MessageParamBase> $additionalMessages = this.getAdditionalMessages();
        result = result * 59 + ($additionalMessages == null ? 43 : ((Object)$additionalMessages).hashCode());
        List<ToolBase> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        TruncationStrategy $truncationStrategy = this.getTruncationStrategy();
        result = result * 59 + ($truncationStrategy == null ? 43 : ((Object)$truncationStrategy).hashCode());
        Object $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        Object $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : $responseFormat.hashCode());
        return result;
    }

    @NonNull
    public String getAssistantId() {
        return this.assistantId;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public String getAdditionalInstructions() {
        return this.additionalInstructions;
    }

    public List<MessageParamBase> getAdditionalMessages() {
        return this.additionalMessages;
    }

    public List<ToolBase> getTools() {
        return this.tools;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public TruncationStrategy getTruncationStrategy() {
        return this.truncationStrategy;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public Object getResponseFormat() {
        return this.responseFormat;
    }

    public void setAssistantId(@NonNull String assistantId) {
        if (assistantId == null) {
            throw new NullPointerException("assistantId is marked non-null but is null");
        }
        this.assistantId = assistantId;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public void setAdditionalInstructions(String additionalInstructions) {
        this.additionalInstructions = additionalInstructions;
    }

    public void setAdditionalMessages(List<MessageParamBase> additionalMessages) {
        this.additionalMessages = additionalMessages;
    }

    public void setTools(List<ToolBase> tools) {
        this.tools = tools;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setMaxPromptTokens(Integer maxPromptTokens) {
        this.maxPromptTokens = maxPromptTokens;
    }

    public void setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
    }

    public void setTruncationStrategy(TruncationStrategy truncationStrategy) {
        this.truncationStrategy = truncationStrategy;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public void setResponseFormat(Object responseFormat) {
        this.responseFormat = responseFormat;
    }

    @Override
    public String toString() {
        return "RunParam(assistantId=" + this.getAssistantId() + ", model=" + this.getModel() + ", instructions=" + this.getInstructions() + ", additionalInstructions=" + this.getAdditionalInstructions() + ", additionalMessages=" + this.getAdditionalMessages() + ", tools=" + this.getTools() + ", metadata=" + this.getMetadata() + ", temperature=" + this.getTemperature() + ", stream=" + this.getStream() + ", maxPromptTokens=" + this.getMaxPromptTokens() + ", maxCompletionTokens=" + this.getMaxCompletionTokens() + ", truncationStrategy=" + this.getTruncationStrategy() + ", toolChoice=" + this.getToolChoice() + ", responseFormat=" + this.getResponseFormat() + ")";
    }

    private static final class RunParamBuilderImpl
    extends RunParamBuilder<RunParam, RunParamBuilderImpl> {
        private RunParamBuilderImpl() {
        }

        @Override
        protected RunParamBuilderImpl self() {
            return this;
        }

        @Override
        public RunParam build() {
            return new RunParam(this);
        }
    }

    public static abstract class RunParamBuilder<C extends RunParam, B extends RunParamBuilder<C, B>>
    extends FlattenHalfDuplexParamBase.FlattenHalfDuplexParamBaseBuilder<C, B> {
        private String assistantId;
        private String model;
        private String instructions;
        private String additionalInstructions;
        private ArrayList<MessageParamBase> additionalMessages;
        private ArrayList<ToolBase> tools;
        private boolean metadata$set;
        private Map<String, String> metadata$value;
        private Float temperature;
        private boolean stream$set;
        private Boolean stream$value;
        private Integer maxPromptTokens;
        private Integer maxCompletionTokens;
        private TruncationStrategy truncationStrategy;
        private Object toolChoice;
        private boolean responseFormat$set;
        private Object responseFormat$value;

        public B assistantId(@NonNull String assistantId) {
            if (assistantId == null) {
                throw new NullPointerException("assistantId is marked non-null but is null");
            }
            this.assistantId = assistantId;
            return (B)this.self();
        }

        public B model(String model) {
            this.model = model;
            return (B)this.self();
        }

        public B instructions(String instructions) {
            this.instructions = instructions;
            return (B)this.self();
        }

        public B additionalInstructions(String additionalInstructions) {
            this.additionalInstructions = additionalInstructions;
            return (B)this.self();
        }

        public B additionalMessage(MessageParamBase additionalMessage) {
            if (this.additionalMessages == null) {
                this.additionalMessages = new ArrayList();
            }
            this.additionalMessages.add(additionalMessage);
            return (B)this.self();
        }

        public B additionalMessages(Collection<? extends MessageParamBase> additionalMessages) {
            if (additionalMessages == null) {
                throw new NullPointerException("additionalMessages cannot be null");
            }
            if (this.additionalMessages == null) {
                this.additionalMessages = new ArrayList();
            }
            this.additionalMessages.addAll(additionalMessages);
            return (B)this.self();
        }

        public B clearAdditionalMessages() {
            if (this.additionalMessages != null) {
                this.additionalMessages.clear();
            }
            return (B)this.self();
        }

        public B tool(ToolBase tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return (B)this.self();
        }

        public B tools(Collection<? extends ToolBase> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return (B)this.self();
        }

        public B clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return (B)this.self();
        }

        public B metadata(Map<String, String> metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return (B)this.self();
        }

        public B temperature(Float temperature) {
            this.temperature = temperature;
            return (B)this.self();
        }

        public B stream(Boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return (B)this.self();
        }

        public B maxPromptTokens(Integer maxPromptTokens) {
            this.maxPromptTokens = maxPromptTokens;
            return (B)this.self();
        }

        public B maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return (B)this.self();
        }

        public B truncationStrategy(TruncationStrategy truncationStrategy) {
            this.truncationStrategy = truncationStrategy;
            return (B)this.self();
        }

        public B toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return (B)this.self();
        }

        public B responseFormat(Object responseFormat) {
            this.responseFormat$value = responseFormat;
            this.responseFormat$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "RunParam.RunParamBuilder(super=" + super.toString() + ", assistantId=" + this.assistantId + ", model=" + this.model + ", instructions=" + this.instructions + ", additionalInstructions=" + this.additionalInstructions + ", additionalMessages=" + this.additionalMessages + ", tools=" + this.tools + ", metadata$value=" + this.metadata$value + ", temperature=" + this.temperature + ", stream$value=" + this.stream$value + ", maxPromptTokens=" + this.maxPromptTokens + ", maxCompletionTokens=" + this.maxCompletionTokens + ", truncationStrategy=" + this.truncationStrategy + ", toolChoice=" + this.toolChoice + ", responseFormat$value=" + this.responseFormat$value + ")";
        }
    }

    public static class TruncationStrategy {
        private String type;
        @SerializedName(value="last_messages")
        private Integer lastMessages;

        public String getType() {
            return this.type;
        }

        public Integer getLastMessages() {
            return this.lastMessages;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setLastMessages(Integer lastMessages) {
            this.lastMessages = lastMessages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TruncationStrategy)) {
                return false;
            }
            TruncationStrategy other = (TruncationStrategy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$lastMessages = this.getLastMessages();
            Integer other$lastMessages = other.getLastMessages();
            if (this$lastMessages == null ? other$lastMessages != null : !((Object)this$lastMessages).equals(other$lastMessages)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TruncationStrategy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $lastMessages = this.getLastMessages();
            result = result * 59 + ($lastMessages == null ? 43 : ((Object)$lastMessages).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "RunParam.TruncationStrategy(type=" + this.getType() + ", lastMessages=" + this.getLastMessages() + ")";
        }
    }
}

