/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.translation;

import com.alibaba.dashscope.api.SynchronizeFullDuplexApi;
import com.alibaba.dashscope.audio.asr.translation.TranslationRecognizerParam;
import com.alibaba.dashscope.audio.asr.translation.TranslationRecognizerState;
import com.alibaba.dashscope.audio.asr.translation.results.TranslationRecognizerResult;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslationRecognizerChat {
    private static final Logger log = LoggerFactory.getLogger(TranslationRecognizerChat.class);
    SynchronizeFullDuplexApi<TranslationRecognizerParamWithStream> duplexApi;
    private ApiServiceOption serviceOption;
    private Emitter<ByteBuffer> audioEmitter;
    private final Queue<AsyncCmdBuffer> cmdBuffer = new LinkedList<AsyncCmdBuffer>();
    private TranslationRecognizerState state = TranslationRecognizerState.IDLE;
    private AtomicReference<CountDownLatch> stopLatch = new AtomicReference<Object>(null);
    private long startStreamTimeStamp = -1L;
    private long firstPackageTimeStamp = -1L;
    private long stopStreamTimeStamp = -1L;
    private long onCompleteTimeStamp = -1L;
    private AtomicBoolean isSentenceEnd = new AtomicBoolean(false);
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private String preRequestId = null;

    public TranslationRecognizerChat() {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.ASR.getValue())).function(Function.SPEECH_TRANSLATION.getValue())).build();
        this.duplexApi = new SynchronizeFullDuplexApi(this.serviceOption);
    }

    public TranslationRecognizerChat(String baseUrl) {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.ASR.getValue())).function(Function.SPEECH_TRANSLATION.getValue())).baseWebSocketUrl(baseUrl)).build();
        this.duplexApi = new SynchronizeFullDuplexApi(this.serviceOption);
    }

    public TranslationRecognizerChat(String baseUrl, ConnectionOptions connectionOptions) {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.ASR.getValue())).function(Function.SPEECH_TRANSLATION.getValue())).baseWebSocketUrl(baseUrl)).build();
        this.duplexApi = new SynchronizeFullDuplexApi(connectionOptions, this.serviceOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(TranslationRecognizerParam param, final ResultCallback<TranslationRecognizerResult> callback) {
        block7: {
            this.reset();
            if (param == null) {
                throw new ApiException(new InputRequiredException("Parameter invalid: TranslationRecognizerParam is null"));
            }
            if (callback == null) {
                throw new ApiException(new InputRequiredException("Parameter invalid: ResultCallback is null"));
            }
            Flowable audioFrames = Flowable.create(emitter -> {
                TranslationRecognizerChat translationRecognizerChat = this;
                synchronized (translationRecognizerChat) {
                    if (this.cmdBuffer.size() > 0) {
                        for (AsyncCmdBuffer buffer : this.cmdBuffer) {
                            if (buffer.isStop) {
                                emitter.onComplete();
                                return;
                            }
                            emitter.onNext((Object)buffer.audioFrame);
                        }
                        this.cmdBuffer.clear();
                    }
                    this.audioEmitter = emitter;
                }
            }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
            TranslationRecognizerChat translationRecognizerChat = this;
            synchronized (translationRecognizerChat) {
                this.state = TranslationRecognizerState.SPEECH_TRANSLATION_STARTED;
                this.cmdBuffer.clear();
            }
            this.stopLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
            this.preRequestId = UUID.randomUUID().toString();
            try {
                this.duplexApi.duplexCall(TranslationRecognizerParamWithStream.FromTranslationRecognizerParam(param, (Flowable<ByteBuffer>)audioFrames, this.preRequestId), new ResultCallback<DashScopeResult>(){

                    @Override
                    public void onEvent(DashScopeResult message) {
                        TranslationRecognizerResult translationRecognizerResult = TranslationRecognizerResult.fromDashScopeResult(message);
                        if (!translationRecognizerResult.isCompleteResult()) {
                            if (TranslationRecognizerChat.this.firstPackageTimeStamp < 0L) {
                                TranslationRecognizerChat.this.firstPackageTimeStamp = System.currentTimeMillis();
                                log.debug("first package delay: " + TranslationRecognizerChat.this.getFirstPackageDelay());
                            }
                            log.debug("[Recv Result] transcription: " + translationRecognizerResult.getTranslationResult() + " translation: " + translationRecognizerResult.getTranscriptionResult());
                            if (translationRecognizerResult.isSentenceEnd()) {
                                log.debug("[Chat] recv sentence end, stop asr");
                                TranslationRecognizerChat.this.isSentenceEnd.set(true);
                            }
                            callback.onEvent(translationRecognizerResult);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onComplete() {
                        TranslationRecognizerChat.this.onCompleteTimeStamp = System.currentTimeMillis();
                        log.debug("last package delay: " + TranslationRecognizerChat.this.getLastPackageDelay());
                        TranslationRecognizerChat translationRecognizerChat = TranslationRecognizerChat.this;
                        synchronized (translationRecognizerChat) {
                            TranslationRecognizerChat.this.state = TranslationRecognizerState.IDLE;
                        }
                        callback.onComplete();
                        if (TranslationRecognizerChat.this.stopLatch.get() != null) {
                            ((CountDownLatch)TranslationRecognizerChat.this.stopLatch.get()).countDown();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onError(Exception e) {
                        TranslationRecognizerChat translationRecognizerChat = TranslationRecognizerChat.this;
                        synchronized (translationRecognizerChat) {
                            TranslationRecognizerChat.this.state = TranslationRecognizerState.IDLE;
                        }
                        ApiException apiException = new ApiException(e);
                        apiException.setStackTrace(e.getStackTrace());
                        callback.onError(apiException);
                        if (TranslationRecognizerChat.this.stopLatch.get() != null) {
                            ((CountDownLatch)TranslationRecognizerChat.this.stopLatch.get()).countDown();
                        }
                    }
                });
            }
            catch (NoApiKeyException e) {
                ApiException apiException = new ApiException(e);
                apiException.setStackTrace(e.getStackTrace());
                callback.onError(apiException);
                if (this.stopLatch.get() == null) break block7;
                this.stopLatch.get().countDown();
            }
        }
        log.debug("TranslationRecognizerChat started, state is {}", (Object)this.state.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendAudioFrame(ByteBuffer audioFrame) {
        if (this.isSentenceEnd.get()) {
            log.debug("skip audio due to has sentence end");
            return false;
        }
        if (audioFrame == null) {
            throw new ApiException(new InputRequiredException("Parameter invalid: audioFrame is null"));
        }
        if (this.startStreamTimeStamp < 0L) {
            this.startStreamTimeStamp = System.currentTimeMillis();
        }
        log.debug("send audio frame: " + audioFrame.remaining());
        TranslationRecognizerChat translationRecognizerChat = this;
        synchronized (translationRecognizerChat) {
            if (this.state != TranslationRecognizerState.SPEECH_TRANSLATION_STARTED) {
                throw new ApiException(new InputRequiredException("State invalid: expect recognition state is started but " + this.state.getValue()));
            }
            if (this.audioEmitter == null) {
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().audioFrame(audioFrame)).build());
            } else {
                this.audioEmitter.onNext((Object)audioFrame);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopStreamTimeStamp = System.currentTimeMillis();
        if (this.stopped.get()) {
            log.debug("TranslationRecognizerChat has already been stopped, skip");
            return;
        }
        log.debug("stop TranslationRecognizerChat");
        TranslationRecognizerChat translationRecognizerChat = this;
        synchronized (translationRecognizerChat) {
            if (this.state != TranslationRecognizerState.SPEECH_TRANSLATION_STARTED) {
                throw new ApiException(new RuntimeException("State invalid: expect recognition state is started but " + this.state.getValue()));
            }
            if (this.audioEmitter == null) {
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().isStop(true)).build());
            } else {
                this.audioEmitter.onComplete();
            }
        }
        if (this.stopLatch.get() != null) {
            try {
                log.debug("start waiting for task-finished");
                this.stopLatch.get().await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.stopped.set(true);
    }

    private void reset() {
        this.audioEmitter = null;
        this.cmdBuffer.clear();
        this.state = TranslationRecognizerState.IDLE;
        this.stopLatch = new AtomicReference<Object>(null);
        this.startStreamTimeStamp = -1L;
        this.firstPackageTimeStamp = -1L;
        this.isSentenceEnd.set(false);
        this.stopped.set(false);
        this.preRequestId = null;
    }

    public long getFirstPackageDelay() {
        return this.firstPackageTimeStamp - this.startStreamTimeStamp;
    }

    public long getLastPackageDelay() {
        return this.onCompleteTimeStamp - this.stopStreamTimeStamp;
    }

    public String getLastRequestId() {
        return this.preRequestId;
    }

    public SynchronizeFullDuplexApi<TranslationRecognizerParamWithStream> getDuplexApi() {
        return this.duplexApi;
    }

    private static class TranslationRecognizerParamWithStream
    extends TranslationRecognizerParam {
        @NonNull
        private Flowable<ByteBuffer> audioStream;

        @Override
        public Flowable<Object> getStreamingData() {
            return this.audioStream.cast(Object.class);
        }

        public static TranslationRecognizerParamWithStream FromTranslationRecognizerParam(TranslationRecognizerParam param, Flowable<ByteBuffer> audioStream, String preRequestId) {
            TranslationRecognizerParam translationRecognizerParamWithStream = ((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParam.TranslationRecognizerParamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)TranslationRecognizerParamWithStream.builder().parameters(param.getParameters())).parameter("pre_task_id", preRequestId)).headers(param.getHeaders())).format(param.getFormat())).audioStream(audioStream)).disfluencyRemovalEnabled(param.isDisfluencyRemovalEnabled())).model(param.getModel())).sampleRate(param.getSampleRate())).apiKey(param.getApiKey())).build();
            if (param.getPhraseId() != null && !param.getPhraseId().isEmpty()) {
                translationRecognizerParamWithStream.setPhraseId(param.getPhraseId());
            }
            return translationRecognizerParamWithStream;
        }

        protected TranslationRecognizerParamWithStream(TranslationRecognizerParamWithStreamBuilder<?, ?> b) {
            super((TranslationRecognizerParam.TranslationRecognizerParamBuilder<?, ?>)b);
            this.audioStream = ((TranslationRecognizerParamWithStreamBuilder)b).audioStream;
            if (this.audioStream == null) {
                throw new NullPointerException("audioStream is marked non-null but is null");
            }
        }

        public static TranslationRecognizerParamWithStreamBuilder<?, ?> builder() {
            return new TranslationRecognizerParamWithStreamBuilderImpl();
        }

        private static final class TranslationRecognizerParamWithStreamBuilderImpl
        extends TranslationRecognizerParamWithStreamBuilder<TranslationRecognizerParamWithStream, TranslationRecognizerParamWithStreamBuilderImpl> {
            private TranslationRecognizerParamWithStreamBuilderImpl() {
            }

            @Override
            protected TranslationRecognizerParamWithStreamBuilderImpl self() {
                return this;
            }

            @Override
            public TranslationRecognizerParamWithStream build() {
                return new TranslationRecognizerParamWithStream(this);
            }
        }

        public static abstract class TranslationRecognizerParamWithStreamBuilder<C extends TranslationRecognizerParamWithStream, B extends TranslationRecognizerParamWithStreamBuilder<C, B>>
        extends TranslationRecognizerParam.TranslationRecognizerParamBuilder<C, B> {
            private Flowable<ByteBuffer> audioStream;

            public B audioStream(@NonNull Flowable<ByteBuffer> audioStream) {
                if (audioStream == null) {
                    throw new NullPointerException("audioStream is marked non-null but is null");
                }
                this.audioStream = audioStream;
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "TranslationRecognizerChat.TranslationRecognizerParamWithStream.TranslationRecognizerParamWithStreamBuilder(super=" + super.toString() + ", audioStream=" + this.audioStream + ")";
            }
        }
    }

    private static class AsyncCmdBuffer {
        private boolean isStop;
        private ByteBuffer audioFrame;

        private static boolean $default$isStop() {
            return false;
        }

        protected AsyncCmdBuffer(AsyncCmdBufferBuilder<?, ?> b) {
            this.isStop = ((AsyncCmdBufferBuilder)b).isStop$set ? ((AsyncCmdBufferBuilder)b).isStop$value : AsyncCmdBuffer.$default$isStop();
            this.audioFrame = ((AsyncCmdBufferBuilder)b).audioFrame;
        }

        public static AsyncCmdBufferBuilder<?, ?> builder() {
            return new AsyncCmdBufferBuilderImpl();
        }

        private static final class AsyncCmdBufferBuilderImpl
        extends AsyncCmdBufferBuilder<AsyncCmdBuffer, AsyncCmdBufferBuilderImpl> {
            private AsyncCmdBufferBuilderImpl() {
            }

            @Override
            protected AsyncCmdBufferBuilderImpl self() {
                return this;
            }

            @Override
            public AsyncCmdBuffer build() {
                return new AsyncCmdBuffer(this);
            }
        }

        public static abstract class AsyncCmdBufferBuilder<C extends AsyncCmdBuffer, B extends AsyncCmdBufferBuilder<C, B>> {
            private boolean isStop$set;
            private boolean isStop$value;
            private ByteBuffer audioFrame;

            public B isStop(boolean isStop) {
                this.isStop$value = isStop;
                this.isStop$set = true;
                return this.self();
            }

            public B audioFrame(ByteBuffer audioFrame) {
                this.audioFrame = audioFrame;
                return this.self();
            }

            protected abstract B self();

            public abstract C build();

            public String toString() {
                return "TranslationRecognizerChat.AsyncCmdBuffer.AsyncCmdBufferBuilder(isStop$value=" + this.isStop$value + ", audioFrame=" + this.audioFrame + ")";
            }
        }
    }
}

