/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.videosynthesis;

import com.alibaba.dashscope.aigc.videosynthesis.VideoSynthesisOutput;
import com.alibaba.dashscope.aigc.videosynthesis.VideoSynthesisUsage;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoSynthesisResult {
    private static final Logger log = LoggerFactory.getLogger(VideoSynthesisResult.class);
    @SerializedName(value="request_id")
    private String requestId;
    private VideoSynthesisOutput output;
    private VideoSynthesisUsage usage;

    private VideoSynthesisResult() {
    }

    public static VideoSynthesisResult fromDashScopeResult(DashScopeResult dashScopeResult) {
        VideoSynthesisResult result = new VideoSynthesisResult();
        result.requestId = dashScopeResult.getRequestId();
        if (dashScopeResult.getUsage() != null) {
            result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), VideoSynthesisUsage.class));
        }
        if (dashScopeResult.getOutput() != null) {
            VideoSynthesisOutput outputTemp = JsonUtils.fromJsonObject((JsonElement)((JsonObject)dashScopeResult.getOutput()), VideoSynthesisOutput.class);
            result.setOutput(outputTemp);
        } else {
            log.error("Result no output: {}", (Object)dashScopeResult);
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public VideoSynthesisOutput getOutput() {
        return this.output;
    }

    public VideoSynthesisUsage getUsage() {
        return this.usage;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setOutput(VideoSynthesisOutput output) {
        this.output = output;
    }

    public void setUsage(VideoSynthesisUsage usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoSynthesisResult)) {
            return false;
        }
        VideoSynthesisResult other = (VideoSynthesisResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        VideoSynthesisOutput this$output = this.getOutput();
        VideoSynthesisOutput other$output = other.getOutput();
        if (this$output == null ? other$output != null : !((Object)this$output).equals(other$output)) {
            return false;
        }
        VideoSynthesisUsage this$usage = this.getUsage();
        VideoSynthesisUsage other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoSynthesisResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        VideoSynthesisOutput $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        VideoSynthesisUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }

    public String toString() {
        return "VideoSynthesisResult(requestId=" + this.getRequestId() + ", output=" + this.getOutput() + ", usage=" + this.getUsage() + ")";
    }
}

