/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.base.FullDuplexParamBase;
import com.alibaba.dashscope.base.FullDuplexServiceParam;
import com.alibaba.dashscope.multimodal.MultiModalDialog;
import com.alibaba.dashscope.multimodal.MultiModalDialogCallback;
import com.alibaba.dashscope.multimodal.MultiModalRequestParam;
import com.alibaba.dashscope.multimodal.State;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiModalDialogUsage {
    private static final Logger log = LoggerFactory.getLogger(MultiModalDialogUsage.class);
    static State.DialogState currentState;
    static MultiModalDialog conversation;
    static int enterListeningTimes;
    static boolean vqaUseUrl;
    private final String workSpaceId = "";
    private final String appId = "";
    private final String modelName = "multimodal-dialog";

    MultiModalDialogUsage() {
    }

    void testMultimodalVQA() {
        System.out.println("############ Start Test VQA ############");
        vqaUseUrl = true;
        FullDuplexServiceParam params = ((MultiModalRequestParam.MultiModalRequestParamBuilder)((MultiModalRequestParam.MultiModalRequestParamBuilder)((FullDuplexParamBase.FullDuplexParamBaseBuilder)((MultiModalRequestParam.MultiModalRequestParamBuilder)((MultiModalRequestParam.MultiModalRequestParamBuilder)((MultiModalRequestParam.MultiModalRequestParamBuilder)MultiModalRequestParam.builder().customInput(MultiModalRequestParam.CustomInput.builder().workspaceId("").appId("").build())).upStream(MultiModalRequestParam.UpStream.builder().mode("push2talk").audioFormat("pcm").build())).downStream(MultiModalRequestParam.DownStream.builder().voice("longxiaochun_v2").sampleRate(48000).build())).clientInfo(MultiModalRequestParam.ClientInfo.builder().userId("1234").device(MultiModalRequestParam.ClientInfo.Device.builder().uuid("device_1234").build()).build())).model("multimodal-dialog")).apiKey("your-api-key")).build();
        log.debug("params: {}", (Object)JsonUtils.toJson(params));
        conversation = new MultiModalDialog((MultiModalRequestParam)params, MultiModalDialogUsage.getCallback());
        conversation.start();
        while (currentState != State.DialogState.LISTENING) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        conversation.requestToRespond("prompt", "\u62cd\u7167\u770b\u770b\u524d\u9762\u6709\u4ec0\u4e48\u4e1c\u897f", null);
        while (enterListeningTimes < 3) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        conversation.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        System.out.println("############ End Test VQA ############");
    }

    public static void main(String[] args) {
        MultiModalDialogUsage multiModalDialogUsage = new MultiModalDialogUsage();
        multiModalDialogUsage.testMultimodalVQA();
    }

    public static MultiModalDialogCallback getCallback() {
        return new MultiModalDialogCallbackImpl();
    }

    public static List<Object> getMockOSSImage() {
        JsonObject imageObject = new JsonObject();
        JsonObject extraObject = new JsonObject();
        ArrayList<Object> images = new ArrayList<Object>();
        try {
            if (vqaUseUrl) {
                imageObject.addProperty("type", "url");
                imageObject.addProperty("value", "https://help-static-aliyun-doc.aliyuncs.com/assets/img/zh-CN/7043267371/p909896.png");
                imageObject.add("extra", (JsonElement)extraObject);
            } else {
                imageObject.addProperty("type", "base64");
                imageObject.addProperty("value", MultiModalDialogUsage.getLocalImageBase64());
            }
            images.add(imageObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return images;
    }

    public static String getLocalImageBase64() {
        String imagePath = "./**/your-demo.jpg";
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(imagePath));
            byte[] bytes = new byte[fileInputStream.available()];
            fileInputStream.read(bytes);
            fileInputStream.close();
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        enterListeningTimes = 0;
        vqaUseUrl = true;
    }

    public static class MultiModalDialogCallbackImpl
    extends MultiModalDialogCallback {
        @Override
        public void onConnected() {
        }

        @Override
        public void onStarted(String dialogId) {
            log.info("onStarted: {}", (Object)dialogId);
        }

        @Override
        public void onStopped(String dialogId) {
            log.info("onStopped: {}", (Object)dialogId);
        }

        @Override
        public void onSpeechStarted(String dialogId) {
            log.info("onSpeechStarted: {}", (Object)dialogId);
        }

        @Override
        public void onSpeechEnded(String dialogId) {
            log.info("onSpeechEnded: {}", (Object)dialogId);
        }

        @Override
        public void onError(String dialogId, String errorCode, String errorMsg) {
            log.error("onError: {}, {}, {}", new Object[]{dialogId, errorCode, errorMsg});
            ++enterListeningTimes;
        }

        @Override
        public void onStateChanged(State.DialogState state) {
            log.info("onStateChanged: {}", (Object)state);
            currentState = state;
            if (currentState == State.DialogState.LISTENING) {
                log.info("enterListeningTimes: {}", (Object)(++enterListeningTimes));
            }
        }

        @Override
        public void onSpeechAudioData(ByteBuffer audioData) {
        }

        @Override
        public void onRespondingStarted(String dialogId) {
            log.info("onRespondingStarted: {}", (Object)dialogId);
            conversation.localRespondingStarted();
        }

        @Override
        public void onRespondingEnded(String dialogId, JsonObject content) {
            log.info("onRespondingEnded: {}", (Object)dialogId);
            conversation.localRespondingEnded();
        }

        @Override
        public void onRespondingContent(String dialogId, JsonObject content) {
            JsonObject extraInfo;
            log.info("onRespondingContent: {}, {}", (Object)dialogId, (Object)content);
            if (content.has("extra_info") && (extraInfo = content.getAsJsonObject("extra_info")).has("commands")) {
                String commandsStr = extraInfo.get("commands").getAsString();
                log.info("commandsStr: {}", (Object)commandsStr);
                JsonArray commands = (JsonArray)new Gson().fromJson(commandsStr, JsonArray.class);
                for (JsonElement command : commands) {
                    String commandStr;
                    JsonObject commandObj = command.getAsJsonObject();
                    if (!commandObj.has("name") || !(commandStr = commandObj.get("name").getAsString()).equals("visual_qa")) continue;
                    log.info("\u62cd\u7167\u4e86\uff01\uff01\uff01\uff01");
                    MultiModalRequestParam.UpdateParams updateParams = MultiModalRequestParam.UpdateParams.builder().images(MultiModalDialogUsage.getMockOSSImage()).build();
                    conversation.requestToRespond("prompt", "", updateParams);
                }
            }
        }

        @Override
        public void onSpeechContent(String dialogId, JsonObject content) {
            log.info("onSpeechContent: {}, {}", (Object)dialogId, (Object)content);
        }

        @Override
        public void onRequestAccepted(String dialogId) {
            log.info("onRequestAccepted: {}", (Object)dialogId);
        }

        @Override
        public void onClosed() {
            log.info("onClosed");
            ++enterListeningTimes;
        }
    }
}

