/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.base.FullDuplexParamBase;
import com.alibaba.dashscope.base.FullDuplexServiceParam;
import com.alibaba.dashscope.multimodal.tingwu.TingWuRealtime;
import com.alibaba.dashscope.multimodal.tingwu.TingWuRealtimeCallback;
import com.alibaba.dashscope.multimodal.tingwu.TingWuRealtimeParam;
import com.google.gson.JsonObject;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TingWuRealtimeUsage {
    private static final Logger log = LoggerFactory.getLogger(TingWuRealtimeUsage.class);
    public static TingWuRealtimeCallback tingWuRealtimeCallback = new TingWuRealtimeCallback(){

        @Override
        public void onStarted(String taskId) {
            log.debug("onStarted: {}", (Object)taskId);
        }

        @Override
        public void onStopped(String taskId) {
            log.debug("onStopped: {}", (Object)taskId);
        }

        @Override
        public void onError(String errorCode, String errorMsg) {
            log.debug("onError: {}, {}", (Object)errorCode, (Object)errorMsg);
        }

        @Override
        public void onAiResult(String taskId, JsonObject content) {
            log.debug("onAiResult: {}, {}", (Object)taskId, (Object)content.toString());
        }

        @Override
        public void onRecognizeResult(String taskId, JsonObject content) {
            log.debug("onRecognizeResult: {}, {}", (Object)taskId, (Object)content.toString());
        }

        @Override
        public void onSpeechListen(String taskId, String dataId) {
            log.debug("onSpeechListen: {}", (Object)taskId);
        }

        @Override
        public void onClosed() {
            log.debug("onClosed");
        }
    };

    public static void main(String[] args) {
        FullDuplexServiceParam tingWuRealtimeParam = ((TingWuRealtimeParam.TingWuRealtimeParamBuilder)((FullDuplexParamBase.FullDuplexParamBaseBuilder)((TingWuRealtimeParam.TingWuRealtimeParamBuilder)((TingWuRealtimeParam.TingWuRealtimeParamBuilder)((TingWuRealtimeParam.TingWuRealtimeParamBuilder)((TingWuRealtimeParam.TingWuRealtimeParamBuilder)TingWuRealtimeParam.builder().model("tingwu-industrial-instruction")).format("pcm")).sampleRate(16000)).terminology("terminology")).appId("your-app-id")).apiKey("your-api-key")).build();
        Path filePath = Paths.get("local-path/test.pcm", new String[0]);
        TingWuRealtime tingWuRealtime = new TingWuRealtime();
        tingWuRealtime.call((TingWuRealtimeParam)tingWuRealtimeParam, tingWuRealtimeCallback);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        try (FileInputStream fis = new FileInputStream(filePath.toFile());){
            int bytesRead;
            byte[] buffer = new byte[3200];
            while ((bytesRead = fis.read(buffer)) != -1) {
                ByteBuffer byteBuffer = bytesRead < buffer.length ? ByteBuffer.wrap(buffer, 0, bytesRead) : ByteBuffer.wrap(buffer);
                tingWuRealtime.sendAudioFrame(byteBuffer);
                Thread.sleep(100L);
                buffer = new byte[3200];
            }
            tingWuRealtime.stop();
            Thread.sleep(10000L);
            tingWuRealtime.getDuplexApi().close(1000, "bye");
        }
        catch (Exception e) {
            e.printStackTrace();
            tingWuRealtime.getDuplexApi().close(1000, "bye");
        }
        System.exit(0);
    }
}

