/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.generation;

import com.alibaba.dashscope.aigc.generation.GenerationLogprobs;
import com.alibaba.dashscope.aigc.generation.GenerationOutput;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import com.alibaba.dashscope.utils.ParamUtils;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Generation {
    private static final Logger log = LoggerFactory.getLogger(Generation.class);
    private final SynchronizeHalfDuplexApi<HalfDuplexServiceParam> syncApi;
    private final ApiServiceOption serviceOption;
    private final ThreadLocal<Map<Integer, AccumulatedData>> accumulatedDataMap = ThreadLocal.withInitial(HashMap::new);

    private ApiServiceOption defaultApiServiceOption() {
        return ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.OUT)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AIGC.getValue())).task(Task.TEXT_GENERATION.getValue())).function(Function.GENERATION.getValue())).build();
    }

    public Generation() {
        this.serviceOption = this.defaultApiServiceOption();
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public Generation(String protocol) {
        this.serviceOption = this.defaultApiServiceOption();
        this.serviceOption.setProtocol(Protocol.of(protocol));
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public Generation(String protocol, String baseUrl) {
        this.serviceOption = this.defaultApiServiceOption();
        this.serviceOption.setProtocol(Protocol.of(protocol));
        if (protocol.equals(Protocol.HTTP.getValue())) {
            this.serviceOption.setBaseHttpUrl(baseUrl);
        } else {
            this.serviceOption.setBaseWebSocketUrl(baseUrl);
        }
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public Generation(String protocol, String baseUrl, ConnectionOptions connectionOptions) {
        this.serviceOption = this.defaultApiServiceOption();
        this.serviceOption.setProtocol(Protocol.of(protocol));
        if (protocol.equals(Protocol.HTTP.getValue())) {
            this.serviceOption.setBaseHttpUrl(baseUrl);
        } else {
            this.serviceOption.setBaseWebSocketUrl(baseUrl);
        }
        this.syncApi = new SynchronizeHalfDuplexApi(connectionOptions, this.serviceOption);
    }

    public GenerationResult call(HalfDuplexServiceParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        return GenerationResult.fromDashScopeResult(this.syncApi.call(param));
    }

    public void call(HalfDuplexServiceParam param, final ResultCallback<GenerationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        this.syncApi.call(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult message) {
                callback.onEvent(GenerationResult.fromDashScopeResult(message));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public Flowable<GenerationResult> streamCall(HalfDuplexServiceParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        boolean toMergeResponse = this.modifyIncrementalOutput(param);
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        return this.syncApi.streamCall(param).map(GenerationResult::fromDashScopeResult).flatMap(result -> {
            GenerationResult merged = this.mergeSingleResponse((GenerationResult)result, toMergeResponse, param);
            if (merged == null) {
                return Flowable.empty();
            }
            return Flowable.just((Object)merged);
        }).doOnComplete(() -> {
            if (toMergeResponse) {
                this.clearAccumulatedData();
            }
        }).doOnError(throwable -> {
            if (toMergeResponse) {
                this.clearAccumulatedData();
            }
        });
    }

    public void streamCall(final HalfDuplexServiceParam param, final ResultCallback<GenerationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        final boolean toMergeResponse = this.modifyIncrementalOutput(param);
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        this.syncApi.streamCall(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult msg) {
                GenerationResult result = GenerationResult.fromDashScopeResult(msg);
                GenerationResult mergedResult = Generation.this.mergeSingleResponse(result, toMergeResponse, param);
                if (mergedResult != null) {
                    callback.onEvent(mergedResult);
                }
            }

            @Override
            public void onComplete() {
                if (toMergeResponse) {
                    Generation.this.clearAccumulatedData();
                }
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                if (toMergeResponse) {
                    Generation.this.clearAccumulatedData();
                }
                callback.onError(e);
            }
        });
    }

    private boolean modifyIncrementalOutput(HalfDuplexServiceParam param) {
        if (param instanceof GenerationParam) {
            GenerationParam generationParam = (GenerationParam)param;
            Boolean incrementalOutput = generationParam.getIncrementalOutput();
            if (ParamUtils.shouldModifyIncrementalOutput(param.getModel()) && Boolean.FALSE.equals(incrementalOutput)) {
                generationParam.setIncrementalOutput(true);
                return true;
            }
        }
        return false;
    }

    private GenerationResult mergeSingleResponse(GenerationResult result, boolean toMergeResponse, HalfDuplexServiceParam param) {
        boolean allSent;
        if (!toMergeResponse || result == null || result.getOutput() == null) {
            return result;
        }
        Map<Integer, AccumulatedData> accumulatedData = this.accumulatedDataMap.get();
        Integer n = null;
        if (param instanceof GenerationParam) {
            n = ((GenerationParam)param).getN();
        }
        if (n == null) {
            n = 1;
        }
        if (n > 1 && !accumulatedData.isEmpty() && (allSent = accumulatedData.values().stream().allMatch(data -> data.allChoicesSent))) {
            return null;
        }
        if (result.getOutput().getChoices() != null) {
            List<GenerationOutput.Choice> choices = result.getOutput().getChoices();
            if (choices.isEmpty()) {
                return null;
            }
            for (GenerationOutput.Choice choice : choices) {
                List<GenerationLogprobs.Content> currentLogprobsContent;
                Integer choiceIndex = choice.getIndex();
                if (choiceIndex == null) {
                    choiceIndex = 0;
                }
                Iterator<Object> accumulated = accumulatedData.computeIfAbsent(choiceIndex, k -> new AccumulatedData());
                if (choice.getMessage() != null) {
                    List<ToolCallBase> currentToolCalls;
                    String currentReasoningContent;
                    String currentContent;
                    if (choice.getMessage().getRole() != null && !choice.getMessage().getRole().isEmpty()) {
                        ((AccumulatedData)((Object)accumulated)).role = choice.getMessage().getRole();
                    }
                    if ((currentContent = choice.getMessage().getContent()) != null && !currentContent.isEmpty()) {
                        ((AccumulatedData)((Object)accumulated)).content.append(currentContent);
                    }
                    if (((AccumulatedData)((Object)accumulated)).content.length() > 0) {
                        choice.getMessage().setContent(((AccumulatedData)((Object)accumulated)).content.toString());
                    }
                    if ((currentReasoningContent = choice.getMessage().getReasoningContent()) != null && !currentReasoningContent.isEmpty()) {
                        ((AccumulatedData)((Object)accumulated)).reasoningContent.append(currentReasoningContent);
                    }
                    if (((AccumulatedData)((Object)accumulated)).reasoningContent.length() > 0) {
                        choice.getMessage().setReasoningContent(((AccumulatedData)((Object)accumulated)).reasoningContent.toString());
                    }
                    if ((currentToolCalls = choice.getMessage().getToolCalls()) != null && !currentToolCalls.isEmpty()) {
                        this.mergeToolCalls(currentToolCalls, ((AccumulatedData)((Object)accumulated)).toolCalls);
                    }
                    if (!((AccumulatedData)((Object)accumulated)).toolCalls.isEmpty()) {
                        choice.getMessage().setToolCalls(((AccumulatedData)((Object)accumulated)).toolCalls);
                    }
                    if (((AccumulatedData)((Object)accumulated)).role != null && (choice.getMessage().getRole() == null || choice.getMessage().getRole().isEmpty())) {
                        choice.getMessage().setRole(((AccumulatedData)((Object)accumulated)).role);
                    }
                }
                if (choice.getLogprobs() != null && choice.getLogprobs().getContent() != null && !(currentLogprobsContent = choice.getLogprobs().getContent()).isEmpty()) {
                    ((AccumulatedData)((Object)accumulated)).logprobsContent.addAll(currentLogprobsContent);
                }
                if (!((AccumulatedData)((Object)accumulated)).logprobsContent.isEmpty() && choice.getLogprobs() != null) {
                    choice.getLogprobs().setContent(((AccumulatedData)((Object)accumulated)).logprobsContent);
                }
                if (n <= 1 || choice.getFinishReason() == null || choice.getFinishReason().equals("null")) continue;
                ((AccumulatedData)((Object)accumulated)).finishReason = choice.getFinishReason();
                ((AccumulatedData)((Object)accumulated)).finished = true;
            }
            if (n > 1 && result.getUsage() != null && result.getUsage().getOutputTokens() != null && !choices.isEmpty()) {
                Object accumulated;
                Integer choiceIndex = choices.get(0).getIndex();
                if (choiceIndex == null) {
                    choiceIndex = 0;
                }
                if ((accumulated = accumulatedData.get(choiceIndex)) != null) {
                    ((AccumulatedData)accumulated).outputTokens = result.getUsage().getOutputTokens();
                }
            }
            if (n > 1) {
                int finishedCount = 0;
                for (AccumulatedData data2 : accumulatedData.values()) {
                    if (!data2.finished) continue;
                    ++finishedCount;
                }
                String currentFinishReason = null;
                Integer currentChoiceIndex = null;
                for (GenerationOutput.Choice choice : choices) {
                    if (choice.getFinishReason() == null || choice.getFinishReason().equals("null")) continue;
                    currentFinishReason = choice.getFinishReason();
                    currentChoiceIndex = choice.getIndex() != null ? choice.getIndex() : 0;
                    break;
                }
                if (currentFinishReason == null) {
                    return result;
                }
                if ("stop".equals(currentFinishReason)) {
                    if (finishedCount < n) {
                        for (GenerationOutput.Choice choice : choices) {
                            if (choice.getFinishReason() == null || choice.getFinishReason().equals("null")) continue;
                            choice.setFinishReason("null");
                        }
                    } else {
                        for (AccumulatedData data3 : accumulatedData.values()) {
                            data3.allChoicesSent = true;
                        }
                        GenerationOutput output = result.getOutput();
                        ArrayList<GenerationOutput.Choice> allChoices = new ArrayList<GenerationOutput.Choice>();
                        int totalOutputTokens = 0;
                        for (Map.Entry<Integer, AccumulatedData> entry : accumulatedData.entrySet()) {
                            Integer index = entry.getKey();
                            AccumulatedData data4 = entry.getValue();
                            GenerationOutput.Choice finalChoice = output.new GenerationOutput.Choice();
                            finalChoice.setIndex(index);
                            finalChoice.setFinishReason(data4.finishReason);
                            Message message = new Message();
                            message.setRole("assistant");
                            if (data4.content.length() > 0) {
                                message.setContent(data4.content.toString());
                            }
                            if (data4.reasoningContent.length() > 0) {
                                message.setReasoningContent(data4.reasoningContent.toString());
                            }
                            if (!data4.toolCalls.isEmpty()) {
                                message.setToolCalls(data4.toolCalls);
                            }
                            finalChoice.setMessage(message);
                            if (!data4.logprobsContent.isEmpty()) {
                                GenerationLogprobs logprobs = new GenerationLogprobs();
                                logprobs.setContent(new ArrayList<GenerationLogprobs.Content>(data4.logprobsContent));
                                finalChoice.setLogprobs(logprobs);
                            }
                            allChoices.add(finalChoice);
                            if (data4.outputTokens == null) continue;
                            totalOutputTokens += data4.outputTokens.intValue();
                        }
                        output.setChoices(allChoices);
                        if (result.getUsage() != null && totalOutputTokens > 0) {
                            result.getUsage().setOutputTokens(totalOutputTokens);
                            if (result.getUsage().getInputTokens() != null) {
                                result.getUsage().setTotalTokens(result.getUsage().getInputTokens() + totalOutputTokens);
                            }
                        }
                    }
                } else {
                    AccumulatedData currentData = accumulatedData.get(currentChoiceIndex);
                    if (currentData == null || currentData.allChoicesSent) {
                        return null;
                    }
                    currentData.allChoicesSent = true;
                    for (GenerationOutput.Choice choice : choices) {
                        if (choice.getIndex() == null || !choice.getIndex().equals(currentChoiceIndex)) continue;
                        if (result.getUsage() != null && currentData.outputTokens != null) {
                            result.getUsage().setOutputTokens(currentData.outputTokens);
                            if (result.getUsage().getInputTokens() != null) {
                                result.getUsage().setTotalTokens(result.getUsage().getInputTokens() + currentData.outputTokens);
                            }
                        }
                        return result;
                    }
                }
            }
        } else {
            AccumulatedData accumulated = accumulatedData.computeIfAbsent(0, k -> new AccumulatedData());
            String currentText = result.getOutput().getText();
            if (currentText != null && !currentText.isEmpty()) {
                accumulated.content.append(currentText);
            }
            if (accumulated.content.length() > 0) {
                result.getOutput().setText(accumulated.content.toString());
            }
        }
        return result;
    }

    private void mergeToolCalls(List<ToolCallBase> currentToolCalls, List<ToolCallBase> accumulatedToolCalls) {
        for (ToolCallBase currentCall : currentToolCalls) {
            if (currentCall == null || currentCall.getIndex() == null) continue;
            int index = currentCall.getIndex();
            ToolCallBase existingCall = null;
            for (ToolCallBase accCall : accumulatedToolCalls) {
                if (accCall == null || accCall.getIndex() == null || !accCall.getIndex().equals(index)) continue;
                existingCall = accCall;
                break;
            }
            if (existingCall instanceof ToolCallFunction && currentCall instanceof ToolCallFunction) {
                ToolCallFunction existingFunctionCall = (ToolCallFunction)existingCall;
                ToolCallFunction currentFunctionCall = (ToolCallFunction)currentCall;
                if (currentFunctionCall.getFunction() != null) {
                    if (existingFunctionCall.getFunction() == null) {
                        existingFunctionCall.setFunction(existingFunctionCall.new ToolCallFunction.CallFunction());
                    }
                    if (currentFunctionCall.getFunction().getArguments() != null) {
                        String existingArguments = existingFunctionCall.getFunction().getArguments();
                        if (existingArguments == null) {
                            existingArguments = "";
                        }
                        String currentArguments = currentFunctionCall.getFunction().getArguments();
                        existingFunctionCall.getFunction().setArguments(existingArguments + currentArguments);
                    }
                    if (currentFunctionCall.getFunction().getName() != null) {
                        String existingName = existingFunctionCall.getFunction().getName();
                        if (existingName == null) {
                            existingName = "";
                        }
                        String currentName = currentFunctionCall.getFunction().getName();
                        existingFunctionCall.getFunction().setName(existingName + currentName);
                    }
                    if (currentFunctionCall.getFunction().getOutput() != null) {
                        existingFunctionCall.getFunction().setOutput(currentFunctionCall.getFunction().getOutput());
                    }
                }
                if (currentFunctionCall.getIndex() != null) {
                    existingFunctionCall.setIndex(currentFunctionCall.getIndex());
                }
                if (currentFunctionCall.getId() != null && !currentFunctionCall.getId().isEmpty()) {
                    existingFunctionCall.setId(currentFunctionCall.getId());
                }
                if (currentFunctionCall.getType() == null) continue;
                existingFunctionCall.setType(currentFunctionCall.getType());
                continue;
            }
            if (currentCall instanceof ToolCallFunction) {
                ToolCallFunction currentFunctionCall = (ToolCallFunction)currentCall;
                ToolCallFunction newFunctionCall = new ToolCallFunction();
                newFunctionCall.setIndex(currentFunctionCall.getIndex());
                newFunctionCall.setId(currentFunctionCall.getId());
                newFunctionCall.setType(currentFunctionCall.getType());
                if (currentFunctionCall.getFunction() != null) {
                    ToolCallFunction.CallFunction newCallFunction = newFunctionCall.new ToolCallFunction.CallFunction();
                    newCallFunction.setName(currentFunctionCall.getFunction().getName());
                    newCallFunction.setArguments(currentFunctionCall.getFunction().getArguments());
                    newCallFunction.setOutput(currentFunctionCall.getFunction().getOutput());
                    newFunctionCall.setFunction(newCallFunction);
                }
                accumulatedToolCalls.add(newFunctionCall);
                continue;
            }
            accumulatedToolCalls.add(currentCall);
        }
    }

    private void clearAccumulatedData() {
        this.accumulatedDataMap.get().clear();
        this.accumulatedDataMap.remove();
    }

    private static class AccumulatedData {
        StringBuilder content = new StringBuilder();
        StringBuilder reasoningContent = new StringBuilder();
        List<ToolCallBase> toolCalls = new ArrayList<ToolCallBase>();
        List<GenerationLogprobs.Content> logprobsContent = new ArrayList<GenerationLogprobs.Content>();
        boolean finished = false;
        String finishReason = null;
        boolean allChoicesSent = false;
        String role = null;
        Integer outputTokens = null;

        private AccumulatedData() {
        }
    }

    public static class Models {
        @Deprecated
        public static final String QWEN_V1 = "qwen-v1";
        public static final String QWEN_TURBO = "qwen-turbo";
        public static final String BAILIAN_V1 = "bailian-v1";
        public static final String DOLLY_12B_V2 = "dolly-12b-v2";
        @Deprecated
        public static final String QWEN_PLUS_V1 = "qwen-plus-v1";
        public static final String QWEN_PLUS = "qwen-plus";
        public static final String QWEN_MAX = "qwen-max";
    }
}

