/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.multimodalconversation;

import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationMessage;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationOutput;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import com.alibaba.dashscope.utils.ParamUtils;
import com.alibaba.dashscope.utils.PreprocessMessageInput;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiModalConversation {
    private static final Logger log = LoggerFactory.getLogger(MultiModalConversation.class);
    private final SynchronizeHalfDuplexApi<MultiModalConversationParam> syncApi;
    private final ApiServiceOption serviceOption;
    private final ThreadLocal<Map<Integer, AccumulatedData>> accumulatedDataMap = ThreadLocal.withInitial(HashMap::new);

    private ApiServiceOption defaultApiServiceOption() {
        return ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.NONE)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AIGC.getValue())).task(Task.MULTIMODAL_GENERATION.getValue())).function(Function.GENERATION.getValue())).build();
    }

    public MultiModalConversation() {
        this.serviceOption = this.defaultApiServiceOption();
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public MultiModalConversation(String protocol) {
        this.serviceOption = this.defaultApiServiceOption();
        this.serviceOption.setProtocol(Protocol.of(protocol));
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public MultiModalConversation(String protocol, String baseUrl) {
        this.serviceOption = this.defaultApiServiceOption();
        this.serviceOption.setProtocol(Protocol.of(protocol));
        if (Protocol.HTTP.getValue().equals(protocol)) {
            this.serviceOption.setBaseHttpUrl(baseUrl);
        } else {
            this.serviceOption.setBaseWebSocketUrl(baseUrl);
        }
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public MultiModalConversation(String protocol, String baseUrl, ConnectionOptions connectionOptions) {
        this.serviceOption = this.defaultApiServiceOption();
        this.serviceOption.setProtocol(Protocol.of(protocol));
        if (Protocol.HTTP.getValue().equals(protocol)) {
            this.serviceOption.setBaseHttpUrl(baseUrl);
        } else {
            this.serviceOption.setBaseWebSocketUrl(baseUrl);
        }
        this.syncApi = new SynchronizeHalfDuplexApi(connectionOptions, this.serviceOption);
    }

    public MultiModalConversationResult call(MultiModalConversationParam param) throws ApiException, NoApiKeyException, UploadFileException {
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        this.preprocessInput(param);
        return MultiModalConversationResult.fromDashScopeResult(this.syncApi.call(param));
    }

    public void call(MultiModalConversationParam param, final ResultCallback<MultiModalConversationResult> callback) throws ApiException, NoApiKeyException, UploadFileException {
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        this.preprocessInput(param);
        this.syncApi.call(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult message) {
                callback.onEvent(MultiModalConversationResult.fromDashScopeResult(message));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public Flowable<MultiModalConversationResult> streamCall(MultiModalConversationParam param) throws ApiException, NoApiKeyException, UploadFileException {
        boolean toMergeResponse = this.modifyIncrementalOutput(param);
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        this.preprocessInput(param);
        return this.syncApi.streamCall(param).map(MultiModalConversationResult::fromDashScopeResult).map(result -> this.mergeSingleResponse((MultiModalConversationResult)result, toMergeResponse)).doOnComplete(() -> {
            if (toMergeResponse) {
                this.clearAccumulatedData();
            }
        }).doOnError(throwable -> {
            if (toMergeResponse) {
                this.clearAccumulatedData();
            }
        });
    }

    public void streamCall(MultiModalConversationParam param, final ResultCallback<MultiModalConversationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException, UploadFileException {
        param.validate();
        final boolean toMergeResponse = this.modifyIncrementalOutput(param);
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        this.preprocessInput(param);
        this.syncApi.streamCall(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult msg) {
                MultiModalConversationResult result = MultiModalConversationResult.fromDashScopeResult(msg);
                MultiModalConversationResult mergedResult = MultiModalConversation.this.mergeSingleResponse(result, toMergeResponse);
                callback.onEvent(mergedResult);
            }

            @Override
            public void onComplete() {
                if (toMergeResponse) {
                    MultiModalConversation.this.clearAccumulatedData();
                }
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                if (toMergeResponse) {
                    MultiModalConversation.this.clearAccumulatedData();
                }
                callback.onError(e);
            }
        });
    }

    private void preprocessInput(MultiModalConversationParam param) throws NoApiKeyException, UploadFileException {
        boolean hasUpload = false;
        for (Object msg : param.getMessages()) {
            boolean isUpload = false;
            isUpload = msg instanceof MultiModalConversationMessage ? PreprocessMessageInput.preProcessMessageInputs(param.getModel(), ((MultiModalConversationMessage)msg).getContent(), param.getApiKey()) : PreprocessMessageInput.preProcessMultiModalMessageInputs(param.getModel(), (MultiModalMessage)msg, param.getApiKey());
            if (!isUpload || hasUpload) continue;
            hasUpload = true;
        }
        if (hasUpload) {
            param.putHeader("X-DashScope-OssResourceResolve", "enable");
        }
    }

    private boolean modifyIncrementalOutput(MultiModalConversationParam param) {
        Boolean incrementalOutput = param.getIncrementalOutput();
        if (ParamUtils.shouldModifyIncrementalOutput(param.getModel()) && Boolean.FALSE.equals(incrementalOutput)) {
            param.setIncrementalOutput(true);
            return true;
        }
        return false;
    }

    private MultiModalConversationResult mergeSingleResponse(MultiModalConversationResult result, boolean toMergeResponse) {
        if (!toMergeResponse || result == null || result.getOutput() == null) {
            return result;
        }
        Map<Integer, AccumulatedData> accumulatedData = this.accumulatedDataMap.get();
        if (result.getOutput().getChoices() != null) {
            List<MultiModalConversationOutput.Choice> choices = result.getOutput().getChoices();
            for (int choiceIdx = 0; choiceIdx < choices.size(); ++choiceIdx) {
                List<ToolCallBase> currentToolCalls;
                String currentReasoningContent;
                MultiModalConversationOutput.Choice choice = choices.get(choiceIdx);
                AccumulatedData accumulated = accumulatedData.computeIfAbsent(choiceIdx, k -> new AccumulatedData());
                if (choice.getMessage() == null) continue;
                List<Map<String, Object>> currentContent = choice.getMessage().getContent();
                if (currentContent != null && !currentContent.isEmpty()) {
                    this.mergeTextContent(currentContent, accumulated);
                }
                if (!accumulated.content.isEmpty()) {
                    choice.getMessage().setContent(accumulated.content);
                }
                if ((currentReasoningContent = choice.getMessage().getReasoningContent()) != null && !currentReasoningContent.isEmpty()) {
                    accumulated.reasoningContent.append(currentReasoningContent);
                }
                if (accumulated.reasoningContent.length() > 0) {
                    choice.getMessage().setReasoningContent(accumulated.reasoningContent.toString());
                }
                if ((currentToolCalls = choice.getMessage().getToolCalls()) != null && !currentToolCalls.isEmpty()) {
                    this.mergeToolCalls(currentToolCalls, accumulated.toolCalls);
                }
                if (accumulated.toolCalls.isEmpty()) continue;
                choice.getMessage().setToolCalls(accumulated.toolCalls);
            }
        }
        return result;
    }

    private void mergeTextContent(List<Map<String, Object>> currentContent, AccumulatedData accumulated) {
        for (Map<String, Object> contentItem : currentContent) {
            String textValue;
            if (!contentItem.containsKey("text") || (textValue = (String)contentItem.get("text")) == null || textValue.isEmpty()) continue;
            Map<Object, Object> accumulatedTextItem = null;
            for (Map<String, Object> accItem : accumulated.content) {
                if (!accItem.containsKey("text")) continue;
                accumulatedTextItem = accItem;
                break;
            }
            if (accumulatedTextItem == null) {
                accumulatedTextItem = new HashMap<String, String>();
                accumulatedTextItem.put("text", textValue);
                accumulated.content.add(accumulatedTextItem);
                continue;
            }
            String existingText = (String)accumulatedTextItem.get("text");
            if (existingText == null) {
                existingText = "";
            }
            accumulatedTextItem.put("text", existingText + textValue);
        }
    }

    private void mergeToolCalls(List<ToolCallBase> currentToolCalls, List<ToolCallBase> accumulatedToolCalls) {
        for (ToolCallBase currentCall : currentToolCalls) {
            if (currentCall == null || currentCall.getIndex() == null) continue;
            int index = currentCall.getIndex();
            ToolCallBase existingCall = null;
            for (ToolCallBase accCall : accumulatedToolCalls) {
                if (accCall == null || accCall.getIndex() == null || !accCall.getIndex().equals(index)) continue;
                existingCall = accCall;
                break;
            }
            if (existingCall instanceof ToolCallFunction && currentCall instanceof ToolCallFunction) {
                ToolCallFunction existingFunctionCall = (ToolCallFunction)existingCall;
                ToolCallFunction currentFunctionCall = (ToolCallFunction)currentCall;
                if (currentFunctionCall.getFunction() != null) {
                    if (existingFunctionCall.getFunction() == null) {
                        existingFunctionCall.setFunction(existingFunctionCall.new ToolCallFunction.CallFunction());
                    }
                    if (currentFunctionCall.getFunction().getArguments() != null) {
                        String existingArguments = existingFunctionCall.getFunction().getArguments();
                        if (existingArguments == null) {
                            existingArguments = "";
                        }
                        String currentArguments = currentFunctionCall.getFunction().getArguments();
                        existingFunctionCall.getFunction().setArguments(existingArguments + currentArguments);
                    }
                    if (currentFunctionCall.getFunction().getName() != null) {
                        String existingName = existingFunctionCall.getFunction().getName();
                        if (existingName == null) {
                            existingName = "";
                        }
                        String currentName = currentFunctionCall.getFunction().getName();
                        existingFunctionCall.getFunction().setName(existingName + currentName);
                    }
                    if (currentFunctionCall.getFunction().getOutput() != null) {
                        existingFunctionCall.getFunction().setOutput(currentFunctionCall.getFunction().getOutput());
                    }
                }
                if (currentFunctionCall.getIndex() != null) {
                    existingFunctionCall.setIndex(currentFunctionCall.getIndex());
                }
                if (currentFunctionCall.getId() != null && !currentFunctionCall.getId().isEmpty()) {
                    existingFunctionCall.setId(currentFunctionCall.getId());
                }
                if (currentFunctionCall.getType() == null) continue;
                existingFunctionCall.setType(currentFunctionCall.getType());
                continue;
            }
            if (currentCall instanceof ToolCallFunction) {
                ToolCallFunction currentFunctionCall = (ToolCallFunction)currentCall;
                ToolCallFunction newFunctionCall = new ToolCallFunction();
                newFunctionCall.setIndex(currentFunctionCall.getIndex());
                newFunctionCall.setId(currentFunctionCall.getId());
                newFunctionCall.setType(currentFunctionCall.getType());
                if (currentFunctionCall.getFunction() != null) {
                    ToolCallFunction.CallFunction newCallFunction = newFunctionCall.new ToolCallFunction.CallFunction();
                    newCallFunction.setName(currentFunctionCall.getFunction().getName());
                    newCallFunction.setArguments(currentFunctionCall.getFunction().getArguments());
                    newCallFunction.setOutput(currentFunctionCall.getFunction().getOutput());
                    newFunctionCall.setFunction(newCallFunction);
                }
                accumulatedToolCalls.add(newFunctionCall);
                continue;
            }
            accumulatedToolCalls.add(currentCall);
        }
    }

    private void clearAccumulatedData() {
        this.accumulatedDataMap.get().clear();
        this.accumulatedDataMap.remove();
    }

    private static class AccumulatedData {
        List<Map<String, Object>> content = new ArrayList<Map<String, Object>>();
        List<ToolCallBase> toolCalls = new ArrayList<ToolCallBase>();
        StringBuilder reasoningContent = new StringBuilder();

        private AccumulatedData() {
        }
    }

    public static class Models {
        public static final String QWEN_VL_CHAT_V1 = "qwen-vl-chat-v1";
        public static final String QWEN_VL_PLUS = "qwen-vl-plus";
    }
}

