/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.videosynthesis;

import com.alibaba.dashscope.aigc.videosynthesis.VideoSynthesisOutput;
import com.alibaba.dashscope.aigc.videosynthesis.VideoSynthesisUsage;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoSynthesisResult {
    private static final Logger log = LoggerFactory.getLogger(VideoSynthesisResult.class);
    @SerializedName(value="request_id")
    private String requestId;
    private VideoSynthesisOutput output;
    private VideoSynthesisUsage usage;
    @SerializedName(value="status_code")
    private Integer statusCode;
    private String code;
    private String message;

    private VideoSynthesisResult() {
    }

    public static VideoSynthesisResult fromDashScopeResult(DashScopeResult dashScopeResult) {
        VideoSynthesisResult result = new VideoSynthesisResult();
        result.requestId = dashScopeResult.getRequestId();
        result.statusCode = dashScopeResult.getStatusCode();
        result.code = dashScopeResult.getCode();
        result.message = dashScopeResult.getMessage();
        if (dashScopeResult.getUsage() != null) {
            result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), VideoSynthesisUsage.class));
        }
        if (dashScopeResult.getOutput() != null) {
            VideoSynthesisOutput outputTemp = JsonUtils.fromJsonObject((JsonElement)((JsonObject)dashScopeResult.getOutput()), VideoSynthesisOutput.class);
            result.setOutput(outputTemp);
        } else {
            log.error("Result no output: {}", (Object)dashScopeResult);
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public VideoSynthesisOutput getOutput() {
        return this.output;
    }

    public VideoSynthesisUsage getUsage() {
        return this.usage;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setOutput(VideoSynthesisOutput output) {
        this.output = output;
    }

    public void setUsage(VideoSynthesisUsage usage) {
        this.usage = usage;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoSynthesisResult)) {
            return false;
        }
        VideoSynthesisResult other = (VideoSynthesisResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$statusCode = this.getStatusCode();
        Integer other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        VideoSynthesisOutput this$output = this.getOutput();
        VideoSynthesisOutput other$output = other.getOutput();
        if (this$output == null ? other$output != null : !((Object)this$output).equals(other$output)) {
            return false;
        }
        VideoSynthesisUsage this$usage = this.getUsage();
        VideoSynthesisUsage other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoSynthesisResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        VideoSynthesisOutput $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        VideoSynthesisUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "VideoSynthesisResult(requestId=" + this.getRequestId() + ", output=" + this.getOutput() + ", usage=" + this.getUsage() + ", statusCode=" + this.getStatusCode() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ")";
    }
}

