/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.ttsv2.enrollment;

import com.alibaba.dashscope.audio.ttsv2.enrollment.VoiceEnrollmentOperationType;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.util.List;

public class VoiceEnrollmentParam
extends HalfDuplexServiceParam {
    private String prefix;
    private String targetModel;
    private VoiceEnrollmentOperationType operationType;
    private String url;
    private String voiceId;
    private List<String> languageHints = null;
    private int pageIndex;
    private int pageSize;

    protected VoiceEnrollmentParam(HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?> b) {
        super(b);
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject body = new JsonObject();
        body.add("input", (JsonElement)this.getInput());
        body.addProperty("model", this.getModel());
        return body;
    }

    public JsonObject getInput() {
        JsonObject input = new JsonObject();
        switch (this.operationType) {
            case CREATE: {
                input.addProperty("action", this.operationType.getValue());
                input.addProperty("target_model", this.targetModel);
                input.addProperty("prefix", this.prefix);
                input.addProperty("url", this.url);
                if (this.languageHints == null) break;
                input.add("language_hints", (JsonElement)JsonUtils.toJsonArray(this.languageHints));
                break;
            }
            case LIST: {
                input.addProperty("action", this.operationType.getValue());
                if (this.prefix != null) {
                    input.addProperty("prefix", this.prefix);
                }
                input.addProperty("page_index", (Number)this.pageIndex);
                input.addProperty("page_size", (Number)this.pageSize);
                break;
            }
            case QUERY: {
                input.addProperty("action", this.operationType.getValue());
                input.addProperty("voice_id", this.voiceId);
                break;
            }
            case UPDATE: {
                input.addProperty("action", this.operationType.getValue());
                input.addProperty("voice_id", this.voiceId);
                input.addProperty("url", this.url);
                break;
            }
            case DELETE: {
                input.addProperty("action", this.operationType.getValue());
                input.addProperty("voice_id", this.voiceId);
                break;
            }
            default: {
                throw new InvalidParameterException("operationType is not supported, should not be here.");
            }
        }
        return input;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.operationType == null) {
            throw new InputRequiredException("operationType is required");
        }
        switch (this.operationType) {
            case CREATE: {
                if (this.url == null) {
                    throw new InputRequiredException("url is required when Create Voice");
                }
                if (this.prefix == null) {
                    throw new InputRequiredException("prefix is required");
                }
                if (this.targetModel != null) break;
                throw new InputRequiredException("targetModel is required");
            }
            case LIST: {
                if (this.pageIndex < 0) {
                    throw new InputRequiredException("pageIndexs should be greater or equal to 0");
                }
                if (this.pageSize >= 1) break;
                throw new InputRequiredException("pageSize should be greater or equal to 1");
            }
            case QUERY: {
                if (this.voiceId != null) break;
                throw new InputRequiredException("voice id is required when Query Voice");
            }
            case UPDATE: {
                if (this.voiceId == null) {
                    throw new InputRequiredException("voice id is required when Update Voice");
                }
                if (this.url != null) break;
                throw new InputRequiredException("url is required when Update Voice");
            }
            case DELETE: {
                if (this.voiceId != null) break;
                throw new InputRequiredException("voice id is required when Delete Voice");
            }
            default: {
                throw new InvalidParameterException("operationType is not supported, should not be here.");
            }
        }
    }

    protected VoiceEnrollmentParam(VoiceEnrollmentParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.prefix = ((VoiceEnrollmentParamBuilder)b).prefix;
        this.targetModel = ((VoiceEnrollmentParamBuilder)b).targetModel;
        this.operationType = ((VoiceEnrollmentParamBuilder)b).operationType;
        this.url = ((VoiceEnrollmentParamBuilder)b).url;
        this.voiceId = ((VoiceEnrollmentParamBuilder)b).voiceId;
        this.languageHints = ((VoiceEnrollmentParamBuilder)b).languageHints;
        this.pageIndex = ((VoiceEnrollmentParamBuilder)b).pageIndex;
        this.pageSize = ((VoiceEnrollmentParamBuilder)b).pageSize;
    }

    public static VoiceEnrollmentParamBuilder<?, ?> builder() {
        return new VoiceEnrollmentParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoiceEnrollmentParam)) {
            return false;
        }
        VoiceEnrollmentParam other = (VoiceEnrollmentParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageIndex() != other.getPageIndex()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$targetModel = this.getTargetModel();
        String other$targetModel = other.getTargetModel();
        if (this$targetModel == null ? other$targetModel != null : !this$targetModel.equals(other$targetModel)) {
            return false;
        }
        VoiceEnrollmentOperationType this$operationType = this.getOperationType();
        VoiceEnrollmentOperationType other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$voiceId = this.getVoiceId();
        String other$voiceId = other.getVoiceId();
        if (this$voiceId == null ? other$voiceId != null : !this$voiceId.equals(other$voiceId)) {
            return false;
        }
        List<String> this$languageHints = this.getLanguageHints();
        List<String> other$languageHints = other.getLanguageHints();
        return !(this$languageHints == null ? other$languageHints != null : !((Object)this$languageHints).equals(other$languageHints));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VoiceEnrollmentParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageIndex();
        result = result * 59 + this.getPageSize();
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $targetModel = this.getTargetModel();
        result = result * 59 + ($targetModel == null ? 43 : $targetModel.hashCode());
        VoiceEnrollmentOperationType $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $voiceId = this.getVoiceId();
        result = result * 59 + ($voiceId == null ? 43 : $voiceId.hashCode());
        List<String> $languageHints = this.getLanguageHints();
        result = result * 59 + ($languageHints == null ? 43 : ((Object)$languageHints).hashCode());
        return result;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTargetModel() {
        return this.targetModel;
    }

    public VoiceEnrollmentOperationType getOperationType() {
        return this.operationType;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVoiceId() {
        return this.voiceId;
    }

    public List<String> getLanguageHints() {
        return this.languageHints;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setTargetModel(String targetModel) {
        this.targetModel = targetModel;
    }

    public void setOperationType(VoiceEnrollmentOperationType operationType) {
        this.operationType = operationType;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVoiceId(String voiceId) {
        this.voiceId = voiceId;
    }

    public void setLanguageHints(List<String> languageHints) {
        this.languageHints = languageHints;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return "VoiceEnrollmentParam(prefix=" + this.getPrefix() + ", targetModel=" + this.getTargetModel() + ", operationType=" + (Object)((Object)this.getOperationType()) + ", url=" + this.getUrl() + ", voiceId=" + this.getVoiceId() + ", languageHints=" + this.getLanguageHints() + ", pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ")";
    }

    private static final class VoiceEnrollmentParamBuilderImpl
    extends VoiceEnrollmentParamBuilder<VoiceEnrollmentParam, VoiceEnrollmentParamBuilderImpl> {
        private VoiceEnrollmentParamBuilderImpl() {
        }

        @Override
        protected VoiceEnrollmentParamBuilderImpl self() {
            return this;
        }

        @Override
        public VoiceEnrollmentParam build() {
            return new VoiceEnrollmentParam(this);
        }
    }

    public static abstract class VoiceEnrollmentParamBuilder<C extends VoiceEnrollmentParam, B extends VoiceEnrollmentParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private String prefix;
        private String targetModel;
        private VoiceEnrollmentOperationType operationType;
        private String url;
        private String voiceId;
        private List<String> languageHints;
        private int pageIndex;
        private int pageSize;

        public B prefix(String prefix) {
            this.prefix = prefix;
            return (B)this.self();
        }

        public B targetModel(String targetModel) {
            this.targetModel = targetModel;
            return (B)this.self();
        }

        public B operationType(VoiceEnrollmentOperationType operationType) {
            this.operationType = operationType;
            return (B)this.self();
        }

        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        public B voiceId(String voiceId) {
            this.voiceId = voiceId;
            return (B)this.self();
        }

        public B languageHints(List<String> languageHints) {
            this.languageHints = languageHints;
            return (B)this.self();
        }

        public B pageIndex(int pageIndex) {
            this.pageIndex = pageIndex;
            return (B)this.self();
        }

        public B pageSize(int pageSize) {
            this.pageSize = pageSize;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "VoiceEnrollmentParam.VoiceEnrollmentParamBuilder(super=" + super.toString() + ", prefix=" + this.prefix + ", targetModel=" + this.targetModel + ", operationType=" + (Object)((Object)this.operationType) + ", url=" + this.url + ", voiceId=" + this.voiceId + ", languageHints=" + this.languageHints + ", pageIndex=" + this.pageIndex + ", pageSize=" + this.pageSize + ")";
        }
    }
}

