/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.embeddings;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.embeddings.MultiModalEmbeddingItemBase;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.List;
import lombok.NonNull;

public class MultiModalEmbeddingParam
extends HalfDuplexServiceParam {
    @NonNull
    private List<MultiModalEmbeddingItemBase> contents;

    public List<MultiModalEmbeddingItemBase> getContent() {
        return this.contents;
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("model", this.getModel());
        requestObject.add("input", (JsonElement)this.getInput());
        if (this.parameters != null && !this.parameters.isEmpty()) {
            requestObject.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.getParameters()));
        }
        return requestObject;
    }

    public JsonObject getInput() {
        JsonObject input = new JsonObject();
        input.add("contents", (JsonElement)JsonUtils.toJsonArray(this.contents));
        return input;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.contents.isEmpty()) {
            throw new InputRequiredException("contents must not empty");
        }
    }

    protected MultiModalEmbeddingParam(MultiModalEmbeddingParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.contents = ((MultiModalEmbeddingParamBuilder)b).contents;
        if (this.contents == null) {
            throw new NullPointerException("contents is marked non-null but is null");
        }
    }

    public static MultiModalEmbeddingParamBuilder<?, ?> builder() {
        return new MultiModalEmbeddingParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiModalEmbeddingParam)) {
            return false;
        }
        MultiModalEmbeddingParam other = (MultiModalEmbeddingParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<MultiModalEmbeddingItemBase> this$contents = this.contents;
        List<MultiModalEmbeddingItemBase> other$contents = other.contents;
        return !(this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultiModalEmbeddingParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<MultiModalEmbeddingItemBase> $contents = this.contents;
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        return result;
    }

    private static final class MultiModalEmbeddingParamBuilderImpl
    extends MultiModalEmbeddingParamBuilder<MultiModalEmbeddingParam, MultiModalEmbeddingParamBuilderImpl> {
        private MultiModalEmbeddingParamBuilderImpl() {
        }

        @Override
        protected MultiModalEmbeddingParamBuilderImpl self() {
            return this;
        }

        @Override
        public MultiModalEmbeddingParam build() {
            return new MultiModalEmbeddingParam(this);
        }
    }

    public static abstract class MultiModalEmbeddingParamBuilder<C extends MultiModalEmbeddingParam, B extends MultiModalEmbeddingParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private List<MultiModalEmbeddingItemBase> contents;

        public B contents(@NonNull List<MultiModalEmbeddingItemBase> contents) {
            if (contents == null) {
                throw new NullPointerException("contents is marked non-null but is null");
            }
            this.contents = contents;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "MultiModalEmbeddingParam.MultiModalEmbeddingParamBuilder(super=" + super.toString() + ", contents=" + this.contents + ")";
        }
    }
}

