/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.utils;

import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.utils.OSSUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public final class PreprocessInputImage {
    public static boolean checkAndUploadImage(String model, Map<String, String> values, String apiKey) throws NoApiKeyException, UploadFileException {
        boolean isUpload = false;
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String dstValue;
            String v = entry.getValue();
            if (v == null || v.isEmpty() || (dstValue = PreprocessInputImage.checkAndUploadImage(model, apiKey, v)).equals(v)) continue;
            isUpload = true;
            entry.setValue(dstValue);
        }
        return isUpload;
    }

    public static String checkAndUploadImage(String model, String apiKey, String value) throws NoApiKeyException, UploadFileException {
        String dstValue = value;
        if (value.startsWith("http")) {
            return dstValue;
        }
        if (value.startsWith("file://")) {
            try {
                String fileUrl;
                URI fileURI = new URI(value);
                File f = new File(fileURI);
                if (f.exists()) {
                    fileUrl = OSSUtils.upload(model, f.getAbsolutePath(), apiKey);
                    if (fileUrl.isEmpty()) {
                        throw new UploadFileException(String.format("Uploading file: %s failed", value));
                    }
                } else {
                    throw new UploadFileException(String.format("Local file: %s not exists.", value));
                }
                dstValue = fileUrl;
            }
            catch (URISyntaxException e) {
                throw new UploadFileException(e.getMessage());
            }
        }
        return dstValue;
    }
}

