/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.proxy.jdbc;

import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxy;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.proxy.jdbc.TransactionInfo;
import com.alibaba.druid.proxy.jdbc.WrapperProxyImpl;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ConnectionProxyImpl
extends WrapperProxyImpl
implements ConnectionProxy {
    private final Connection connection;
    private final DataSourceProxy dataSource;
    private final Properties properties;
    private final long connectedTime;
    private TransactionInfo transactionInfo;
    private int closeCount;
    private FilterChainImpl filterChain = null;

    public ConnectionProxyImpl(DataSourceProxy dataSource, Connection connection, Properties properties, long id) {
        super(connection, id);
        this.dataSource = dataSource;
        this.connection = connection;
        this.properties = properties;
        this.connectedTime = System.currentTimeMillis();
    }

    @Override
    public Date getConnectedTime() {
        return new Date(this.connectedTime);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public Connection getConnectionRaw() {
        return this.connection;
    }

    @Override
    public Connection getRawObject() {
        return this.connection;
    }

    @Override
    public DataSourceProxy getDirectDataSource() {
        return this.dataSource;
    }

    @Override
    public FilterChainImpl createChain() {
        FilterChainImpl chain = this.filterChain;
        if (chain == null) {
            chain = new FilterChainImpl(this.dataSource);
        } else {
            this.filterChain = null;
        }
        return chain;
    }

    public void recycleFilterChain(FilterChainImpl chain) {
        chain.reset();
        this.filterChain = chain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_clearWarnings(this);
        this.recycleFilterChain(chain);
    }

    @Override
    public void close() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_close(this);
        ++this.closeCount;
        this.recycleFilterChain(chain);
    }

    @Override
    public void commit() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_commit(this);
        if (this.transactionInfo != null) {
            this.transactionInfo.setEndTimeMillis();
        }
        this.recycleFilterChain(chain);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Array value = chain.connection_createArrayOf(this, typeName, elements);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Blob createBlob() throws SQLException {
        FilterChainImpl chain = this.createChain();
        Blob value = chain.connection_createBlob(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Clob createClob() throws SQLException {
        FilterChainImpl chain = this.createChain();
        Clob value = chain.connection_createClob(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public NClob createNClob() throws SQLException {
        FilterChainImpl chain = this.createChain();
        NClob value = chain.connection_createNClob(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        FilterChainImpl chain = this.createChain();
        SQLXML value = chain.connection_createSQLXML(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Statement createStatement() throws SQLException {
        FilterChainImpl chain = this.createChain();
        StatementProxy stmt = chain.connection_createStatement(this);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        FilterChainImpl chain = this.createChain();
        StatementProxy stmt = chain.connection_createStatement(this, resultSetType, resultSetConcurrency);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        FilterChainImpl chain = this.createChain();
        StatementProxy stmt = chain.connection_createStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Struct value = chain.connection_createStruct(this, typeName, attributes);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.connection_getAutoCommit(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public String getCatalog() throws SQLException {
        FilterChainImpl chain = this.createChain();
        String value = chain.connection_getCatalog(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        FilterChainImpl chain = this.createChain();
        Properties value = chain.connection_getClientInfo(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        FilterChainImpl chain = this.createChain();
        String value = chain.connection_getClientInfo(this, name);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getHoldability() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.connection_getHoldability(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        FilterChainImpl chain = this.createChain();
        DatabaseMetaData value = chain.connection_getMetaData(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int value = chain.connection_getTransactionIsolation(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        FilterChainImpl chain = this.createChain();
        Map<String, Class<?>> value = chain.connection_getTypeMap(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        FilterChainImpl chain = this.createChain();
        SQLWarning value = chain.connection_getWarnings(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean isClosed() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.connection_isClosed(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.connection_isReadOnly(this);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        FilterChainImpl chain = this.createChain();
        boolean value = chain.connection_isValid(this, timeout);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        FilterChainImpl chain = this.createChain();
        String value = chain.connection_nativeSQL(this, sql);
        this.recycleFilterChain(chain);
        return value;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        FilterChainImpl chain = this.createChain();
        CallableStatementProxy stmt = chain.connection_prepareCall(this, sql);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        FilterChainImpl chain = this.createChain();
        CallableStatementProxy stmt = chain.connection_prepareCall(this, sql, resultSetType, resultSetConcurrency);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        FilterChainImpl chain = this.createChain();
        CallableStatementProxy stmt = chain.connection_prepareCall(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        FilterChainImpl chain = this.createChain();
        PreparedStatementProxy stmt = chain.connection_prepareStatement(this, sql);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        FilterChainImpl chain = this.createChain();
        PreparedStatementProxy stmt = chain.connection_prepareStatement((ConnectionProxy)this, sql, autoGeneratedKeys);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        FilterChainImpl chain = this.createChain();
        PreparedStatementProxy stmt = chain.connection_prepareStatement((ConnectionProxy)this, sql, columnIndexes);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        FilterChainImpl chain = this.createChain();
        PreparedStatementProxy stmt = chain.connection_prepareStatement((ConnectionProxy)this, sql, columnNames);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        FilterChainImpl chain = this.createChain();
        PreparedStatementProxy stmt = chain.connection_prepareStatement(this, sql, resultSetType, resultSetConcurrency);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        FilterChainImpl chain = this.createChain();
        PreparedStatementProxy stmt = chain.connection_prepareStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.recycleFilterChain(chain);
        return stmt;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_releaseSavepoint(this, savepoint);
        this.recycleFilterChain(chain);
    }

    @Override
    public void rollback() throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_rollback(this);
        this.recycleFilterChain(chain);
        if (this.transactionInfo != null) {
            this.transactionInfo.setEndTimeMillis();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_rollback(this, savepoint);
        this.recycleFilterChain(chain);
        if (this.transactionInfo != null) {
            this.transactionInfo.setEndTimeMillis();
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!autoCommit) {
            if (this.transactionInfo == null) {
                long transactionId = this.dataSource.createTransactionId();
                this.transactionInfo = new TransactionInfo(transactionId);
                this.putAttribute("stat.tx", this.transactionInfo);
            }
        } else {
            this.transactionInfo = null;
        }
        FilterChainImpl chain = this.createChain();
        chain.connection_setAutoCommit(this, autoCommit);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_setCatalog(this, catalog);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        FilterChainImpl chain = this.createChain();
        chain.connection_setClientInfo(this, properties);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        FilterChainImpl chain = this.createChain();
        chain.connection_setClientInfo(this, name, value);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_setHoldability(this, holdability);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_setReadOnly(this, readOnly);
        this.recycleFilterChain(chain);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        FilterChainImpl chain = this.createChain();
        Savepoint savepoint = chain.connection_setSavepoint(this);
        this.recycleFilterChain(chain);
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        FilterChainImpl chain = this.createChain();
        Savepoint savepoint = chain.connection_setSavepoint(this, name);
        this.recycleFilterChain(chain);
        return savepoint;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_setTransactionIsolation(this, level);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_setTypeMap(this, map);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_setSchema(this, schema);
        this.recycleFilterChain(chain);
    }

    @Override
    public String getSchema() throws SQLException {
        FilterChainImpl chain = this.createChain();
        String schema = chain.connection_getSchema(this);
        this.recycleFilterChain(chain);
        return schema;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_abort(this, executor);
        this.recycleFilterChain(chain);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        FilterChainImpl chain = this.createChain();
        chain.connection_setNetworkTimeout(this, executor, milliseconds);
        this.recycleFilterChain(chain);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        FilterChainImpl chain = this.createChain();
        int networkTimeout = chain.connection_getNetworkTimeout(this);
        this.recycleFilterChain(chain);
        return networkTimeout;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == this.getClass() || iface == ConnectionProxy.class) {
            return (T)this;
        }
        return super.unwrap(iface);
    }

    @Override
    public TransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    @Override
    public int getCloseCount() {
        return this.closeCount;
    }
}

